// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Returns information about a pull request event.
 */
public class PullRequestEvent private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the pull request with more commits or changing the status of a pull request.
     */
    public val actorArn: kotlin.String? = builder.actorArn
    /**
     * Information about a pull request event.
     */
    public val approvalRuleEventMetadata: aws.sdk.kotlin.services.codecommit.model.ApprovalRuleEventMetadata? = builder.approvalRuleEventMetadata
    /**
     * Information about an approval rule override event for a pull request.
     */
    public val approvalRuleOverriddenEventMetadata: aws.sdk.kotlin.services.codecommit.model.ApprovalRuleOverriddenEventMetadata? = builder.approvalRuleOverriddenEventMetadata
    /**
     * Information about an approval state change for a pull request.
     */
    public val approvalStateChangedEventMetadata: aws.sdk.kotlin.services.codecommit.model.ApprovalStateChangedEventMetadata? = builder.approvalStateChangedEventMetadata
    /**
     * The day and time of the pull request event, in timestamp format.
     */
    public val eventDate: aws.smithy.kotlin.runtime.time.Instant? = builder.eventDate
    /**
     * Information about the source and destination branches for the pull request.
     */
    public val pullRequestCreatedEventMetadata: aws.sdk.kotlin.services.codecommit.model.PullRequestCreatedEventMetadata? = builder.pullRequestCreatedEventMetadata
    /**
     * The type of the pull request event (for example, a status change event (PULL_REQUEST_STATUS_CHANGED) or update event (PULL_REQUEST_SOURCE_REFERENCE_UPDATED)).
     */
    public val pullRequestEventType: aws.sdk.kotlin.services.codecommit.model.PullRequestEventType? = builder.pullRequestEventType
    /**
     * The system-generated ID of the pull request.
     */
    public val pullRequestId: kotlin.String? = builder.pullRequestId
    /**
     * Information about the change in mergability state for the pull request event.
     */
    public val pullRequestMergedStateChangedEventMetadata: aws.sdk.kotlin.services.codecommit.model.PullRequestMergedStateChangedEventMetadata? = builder.pullRequestMergedStateChangedEventMetadata
    /**
     * Information about the updated source branch for the pull request event.
     */
    public val pullRequestSourceReferenceUpdatedEventMetadata: aws.sdk.kotlin.services.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata? = builder.pullRequestSourceReferenceUpdatedEventMetadata
    /**
     * Information about the change in status for the pull request event.
     */
    public val pullRequestStatusChangedEventMetadata: aws.sdk.kotlin.services.codecommit.model.PullRequestStatusChangedEventMetadata? = builder.pullRequestStatusChangedEventMetadata

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.PullRequestEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PullRequestEvent(")
        append("actorArn=$actorArn,")
        append("approvalRuleEventMetadata=$approvalRuleEventMetadata,")
        append("approvalRuleOverriddenEventMetadata=$approvalRuleOverriddenEventMetadata,")
        append("approvalStateChangedEventMetadata=$approvalStateChangedEventMetadata,")
        append("eventDate=$eventDate,")
        append("pullRequestCreatedEventMetadata=$pullRequestCreatedEventMetadata,")
        append("pullRequestEventType=$pullRequestEventType,")
        append("pullRequestId=$pullRequestId,")
        append("pullRequestMergedStateChangedEventMetadata=$pullRequestMergedStateChangedEventMetadata,")
        append("pullRequestSourceReferenceUpdatedEventMetadata=$pullRequestSourceReferenceUpdatedEventMetadata,")
        append("pullRequestStatusChangedEventMetadata=$pullRequestStatusChangedEventMetadata")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actorArn?.hashCode() ?: 0
        result = 31 * result + (approvalRuleEventMetadata?.hashCode() ?: 0)
        result = 31 * result + (approvalRuleOverriddenEventMetadata?.hashCode() ?: 0)
        result = 31 * result + (approvalStateChangedEventMetadata?.hashCode() ?: 0)
        result = 31 * result + (eventDate?.hashCode() ?: 0)
        result = 31 * result + (pullRequestCreatedEventMetadata?.hashCode() ?: 0)
        result = 31 * result + (pullRequestEventType?.hashCode() ?: 0)
        result = 31 * result + (pullRequestId?.hashCode() ?: 0)
        result = 31 * result + (pullRequestMergedStateChangedEventMetadata?.hashCode() ?: 0)
        result = 31 * result + (pullRequestSourceReferenceUpdatedEventMetadata?.hashCode() ?: 0)
        result = 31 * result + (pullRequestStatusChangedEventMetadata?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PullRequestEvent

        if (actorArn != other.actorArn) return false
        if (approvalRuleEventMetadata != other.approvalRuleEventMetadata) return false
        if (approvalRuleOverriddenEventMetadata != other.approvalRuleOverriddenEventMetadata) return false
        if (approvalStateChangedEventMetadata != other.approvalStateChangedEventMetadata) return false
        if (eventDate != other.eventDate) return false
        if (pullRequestCreatedEventMetadata != other.pullRequestCreatedEventMetadata) return false
        if (pullRequestEventType != other.pullRequestEventType) return false
        if (pullRequestId != other.pullRequestId) return false
        if (pullRequestMergedStateChangedEventMetadata != other.pullRequestMergedStateChangedEventMetadata) return false
        if (pullRequestSourceReferenceUpdatedEventMetadata != other.pullRequestSourceReferenceUpdatedEventMetadata) return false
        if (pullRequestStatusChangedEventMetadata != other.pullRequestStatusChangedEventMetadata) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.PullRequestEvent = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the pull request with more commits or changing the status of a pull request.
         */
        public var actorArn: kotlin.String? = null
        /**
         * Information about a pull request event.
         */
        public var approvalRuleEventMetadata: aws.sdk.kotlin.services.codecommit.model.ApprovalRuleEventMetadata? = null
        /**
         * Information about an approval rule override event for a pull request.
         */
        public var approvalRuleOverriddenEventMetadata: aws.sdk.kotlin.services.codecommit.model.ApprovalRuleOverriddenEventMetadata? = null
        /**
         * Information about an approval state change for a pull request.
         */
        public var approvalStateChangedEventMetadata: aws.sdk.kotlin.services.codecommit.model.ApprovalStateChangedEventMetadata? = null
        /**
         * The day and time of the pull request event, in timestamp format.
         */
        public var eventDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the source and destination branches for the pull request.
         */
        public var pullRequestCreatedEventMetadata: aws.sdk.kotlin.services.codecommit.model.PullRequestCreatedEventMetadata? = null
        /**
         * The type of the pull request event (for example, a status change event (PULL_REQUEST_STATUS_CHANGED) or update event (PULL_REQUEST_SOURCE_REFERENCE_UPDATED)).
         */
        public var pullRequestEventType: aws.sdk.kotlin.services.codecommit.model.PullRequestEventType? = null
        /**
         * The system-generated ID of the pull request.
         */
        public var pullRequestId: kotlin.String? = null
        /**
         * Information about the change in mergability state for the pull request event.
         */
        public var pullRequestMergedStateChangedEventMetadata: aws.sdk.kotlin.services.codecommit.model.PullRequestMergedStateChangedEventMetadata? = null
        /**
         * Information about the updated source branch for the pull request event.
         */
        public var pullRequestSourceReferenceUpdatedEventMetadata: aws.sdk.kotlin.services.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata? = null
        /**
         * Information about the change in status for the pull request event.
         */
        public var pullRequestStatusChangedEventMetadata: aws.sdk.kotlin.services.codecommit.model.PullRequestStatusChangedEventMetadata? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.PullRequestEvent) : this() {
            this.actorArn = x.actorArn
            this.approvalRuleEventMetadata = x.approvalRuleEventMetadata
            this.approvalRuleOverriddenEventMetadata = x.approvalRuleOverriddenEventMetadata
            this.approvalStateChangedEventMetadata = x.approvalStateChangedEventMetadata
            this.eventDate = x.eventDate
            this.pullRequestCreatedEventMetadata = x.pullRequestCreatedEventMetadata
            this.pullRequestEventType = x.pullRequestEventType
            this.pullRequestId = x.pullRequestId
            this.pullRequestMergedStateChangedEventMetadata = x.pullRequestMergedStateChangedEventMetadata
            this.pullRequestSourceReferenceUpdatedEventMetadata = x.pullRequestSourceReferenceUpdatedEventMetadata
            this.pullRequestStatusChangedEventMetadata = x.pullRequestStatusChangedEventMetadata
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.PullRequestEvent = PullRequestEvent(this)

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.ApprovalRuleEventMetadata] inside the given [block]
         */
        public fun approvalRuleEventMetadata(block: aws.sdk.kotlin.services.codecommit.model.ApprovalRuleEventMetadata.Builder.() -> kotlin.Unit) {
            this.approvalRuleEventMetadata = aws.sdk.kotlin.services.codecommit.model.ApprovalRuleEventMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.ApprovalRuleOverriddenEventMetadata] inside the given [block]
         */
        public fun approvalRuleOverriddenEventMetadata(block: aws.sdk.kotlin.services.codecommit.model.ApprovalRuleOverriddenEventMetadata.Builder.() -> kotlin.Unit) {
            this.approvalRuleOverriddenEventMetadata = aws.sdk.kotlin.services.codecommit.model.ApprovalRuleOverriddenEventMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.ApprovalStateChangedEventMetadata] inside the given [block]
         */
        public fun approvalStateChangedEventMetadata(block: aws.sdk.kotlin.services.codecommit.model.ApprovalStateChangedEventMetadata.Builder.() -> kotlin.Unit) {
            this.approvalStateChangedEventMetadata = aws.sdk.kotlin.services.codecommit.model.ApprovalStateChangedEventMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.PullRequestCreatedEventMetadata] inside the given [block]
         */
        public fun pullRequestCreatedEventMetadata(block: aws.sdk.kotlin.services.codecommit.model.PullRequestCreatedEventMetadata.Builder.() -> kotlin.Unit) {
            this.pullRequestCreatedEventMetadata = aws.sdk.kotlin.services.codecommit.model.PullRequestCreatedEventMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.PullRequestMergedStateChangedEventMetadata] inside the given [block]
         */
        public fun pullRequestMergedStateChangedEventMetadata(block: aws.sdk.kotlin.services.codecommit.model.PullRequestMergedStateChangedEventMetadata.Builder.() -> kotlin.Unit) {
            this.pullRequestMergedStateChangedEventMetadata = aws.sdk.kotlin.services.codecommit.model.PullRequestMergedStateChangedEventMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata] inside the given [block]
         */
        public fun pullRequestSourceReferenceUpdatedEventMetadata(block: aws.sdk.kotlin.services.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata.Builder.() -> kotlin.Unit) {
            this.pullRequestSourceReferenceUpdatedEventMetadata = aws.sdk.kotlin.services.codecommit.model.PullRequestSourceReferenceUpdatedEventMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.PullRequestStatusChangedEventMetadata] inside the given [block]
         */
        public fun pullRequestStatusChangedEventMetadata(block: aws.sdk.kotlin.services.codecommit.model.PullRequestStatusChangedEventMetadata.Builder.() -> kotlin.Unit) {
            this.pullRequestStatusChangedEventMetadata = aws.sdk.kotlin.services.codecommit.model.PullRequestStatusChangedEventMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
