// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetMergeConflictsResponse private constructor(builder: Builder) {
    /**
     * The commit ID of the merge base.
     */
    public val baseCommitId: kotlin.String? = builder.baseCommitId
    /**
     * A list of metadata for any conflicting files. If the specified merge strategy is FAST_FORWARD_MERGE, this list is always empty.
     */
    public val conflictMetadataList: List<ConflictMetadata> = requireNotNull(builder.conflictMetadataList) { "A non-null value must be provided for conflictMetadataList" }
    /**
     * The commit ID of the destination commit specifier that was used in the merge evaluation.
     */
    public val destinationCommitId: kotlin.String = requireNotNull(builder.destinationCommitId) { "A non-null value must be provided for destinationCommitId" }
    /**
     * A Boolean value that indicates whether the code is mergeable by the specified merge option.
     */
    public val mergeable: kotlin.Boolean = builder.mergeable
    /**
     * An enumeration token that can be used in a request to return the next batch of the results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The commit ID of the source commit specifier that was used in the merge evaluation.
     */
    public val sourceCommitId: kotlin.String = requireNotNull(builder.sourceCommitId) { "A non-null value must be provided for sourceCommitId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.GetMergeConflictsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMergeConflictsResponse(")
        append("baseCommitId=$baseCommitId,")
        append("conflictMetadataList=$conflictMetadataList,")
        append("destinationCommitId=$destinationCommitId,")
        append("mergeable=$mergeable,")
        append("nextToken=$nextToken,")
        append("sourceCommitId=$sourceCommitId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baseCommitId?.hashCode() ?: 0
        result = 31 * result + (conflictMetadataList.hashCode())
        result = 31 * result + (destinationCommitId.hashCode())
        result = 31 * result + (mergeable.hashCode())
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sourceCommitId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMergeConflictsResponse

        if (baseCommitId != other.baseCommitId) return false
        if (conflictMetadataList != other.conflictMetadataList) return false
        if (destinationCommitId != other.destinationCommitId) return false
        if (mergeable != other.mergeable) return false
        if (nextToken != other.nextToken) return false
        if (sourceCommitId != other.sourceCommitId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.GetMergeConflictsResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The commit ID of the merge base.
         */
        public var baseCommitId: kotlin.String? = null
        /**
         * A list of metadata for any conflicting files. If the specified merge strategy is FAST_FORWARD_MERGE, this list is always empty.
         */
        public var conflictMetadataList: List<ConflictMetadata>? = null
        /**
         * The commit ID of the destination commit specifier that was used in the merge evaluation.
         */
        public var destinationCommitId: kotlin.String? = null
        /**
         * A Boolean value that indicates whether the code is mergeable by the specified merge option.
         */
        public var mergeable: kotlin.Boolean = false
        /**
         * An enumeration token that can be used in a request to return the next batch of the results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The commit ID of the source commit specifier that was used in the merge evaluation.
         */
        public var sourceCommitId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.GetMergeConflictsResponse) : this() {
            this.baseCommitId = x.baseCommitId
            this.conflictMetadataList = x.conflictMetadataList
            this.destinationCommitId = x.destinationCommitId
            this.mergeable = x.mergeable
            this.nextToken = x.nextToken
            this.sourceCommitId = x.sourceCommitId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.GetMergeConflictsResponse = GetMergeConflictsResponse(this)

        internal fun correctErrors(): Builder {
            if (conflictMetadataList == null) conflictMetadataList = emptyList()
            if (destinationCommitId == null) destinationCommitId = ""
            if (sourceCommitId == null) sourceCommitId = ""
            return this
        }
    }
}
