// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a version of a file.
 */
public class FileVersion private constructor(builder: Builder) {
    /**
     * The blob ID of the object that represents the content of the file in this version.
     */
    public val blobId: kotlin.String? = builder.blobId
    /**
     * Returns information about a specific commit.
     */
    public val commit: aws.sdk.kotlin.services.codecommit.model.Commit? = builder.commit
    /**
     * The name and path of the file at which this blob is indexed which contains the data for this version of the file. This value will vary between file versions if a file is renamed or if its path changes.
     */
    public val path: kotlin.String? = builder.path
    /**
     * An array of commit IDs that contain more recent versions of this file. If there are no additional versions of the file, this array will be empty.
     */
    public val revisionChildren: List<String>? = builder.revisionChildren

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.FileVersion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FileVersion(")
        append("blobId=$blobId,")
        append("commit=$commit,")
        append("path=$path,")
        append("revisionChildren=$revisionChildren")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blobId?.hashCode() ?: 0
        result = 31 * result + (commit?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (revisionChildren?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FileVersion

        if (blobId != other.blobId) return false
        if (commit != other.commit) return false
        if (path != other.path) return false
        if (revisionChildren != other.revisionChildren) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.FileVersion = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The blob ID of the object that represents the content of the file in this version.
         */
        public var blobId: kotlin.String? = null
        /**
         * Returns information about a specific commit.
         */
        public var commit: aws.sdk.kotlin.services.codecommit.model.Commit? = null
        /**
         * The name and path of the file at which this blob is indexed which contains the data for this version of the file. This value will vary between file versions if a file is renamed or if its path changes.
         */
        public var path: kotlin.String? = null
        /**
         * An array of commit IDs that contain more recent versions of this file. If there are no additional versions of the file, this array will be empty.
         */
        public var revisionChildren: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.FileVersion) : this() {
            this.blobId = x.blobId
            this.commit = x.commit
            this.path = x.path
            this.revisionChildren = x.revisionChildren
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.FileVersion = FileVersion(this)

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.Commit] inside the given [block]
         */
        public fun commit(block: aws.sdk.kotlin.services.codecommit.model.Commit.Builder.() -> kotlin.Unit) {
            this.commit = aws.sdk.kotlin.services.codecommit.model.Commit.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
