// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestApprovalStateResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdatePullRequestApprovalStateOperationDeserializer: HttpDeserializer.NonStreaming<UpdatePullRequestApprovalStateResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdatePullRequestApprovalStateResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdatePullRequestApprovalStateError(context, call, payload)
        }
        val builder = UpdatePullRequestApprovalStateResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdatePullRequestApprovalStateError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "MaximumNumberOfApprovalsExceededException" -> MaximumNumberOfApprovalsExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidPullRequestIdException" -> InvalidPullRequestIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PullRequestAlreadyClosedException" -> PullRequestAlreadyClosedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidApprovalStateException" -> InvalidApprovalStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PullRequestCannotBeApprovedByAuthorException" -> PullRequestCannotBeApprovedByAuthorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ApprovalStateRequiredException" -> ApprovalStateRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RevisionIdRequiredException" -> RevisionIdRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRevisionIdException" -> InvalidRevisionIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PullRequestDoesNotExistException" -> PullRequestDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PullRequestIdRequiredException" -> PullRequestIdRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RevisionNotCurrentException" -> RevisionNotCurrentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
