// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.PutCommentReactionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class PutCommentReactionOperationDeserializer: HttpDeserializer.NonStreaming<PutCommentReactionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutCommentReactionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutCommentReactionError(context, call, payload)
        }
        val builder = PutCommentReactionResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutCommentReactionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ReactionLimitExceededException" -> ReactionLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCommentIdException" -> InvalidCommentIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidReactionValueException" -> InvalidReactionValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommentIdRequiredException" -> CommentIdRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommentDoesNotExistException" -> CommentDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ReactionValueRequiredException" -> ReactionValueRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommentDeletedException" -> CommentDeletedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
