// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.Comment
import aws.sdk.kotlin.services.codecommit.model.PostCommentReplyResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PostCommentReplyOperationDeserializer: HttpDeserializer.NonStreaming<PostCommentReplyResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PostCommentReplyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPostCommentReplyError(context, call, payload)
        }
        val builder = PostCommentReplyResponse.Builder()

        if (payload != null) {
            deserializePostCommentReplyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPostCommentReplyError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidCommentIdException" -> InvalidCommentIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommentContentRequiredException" -> CommentContentRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommentIdRequiredException" -> CommentIdRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClientRequestTokenException" -> InvalidClientRequestTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommentDoesNotExistException" -> CommentDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ClientRequestTokenRequiredException" -> ClientRequestTokenRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommentContentSizeLimitExceededException" -> CommentContentSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IdempotencyParameterMismatchException" -> IdempotencyParameterMismatchExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePostCommentReplyOperationBody(builder: PostCommentReplyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("comment"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMMENT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMMENT_DESCRIPTOR.index -> builder.comment = deserializeCommentDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
