// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.Comment
import aws.sdk.kotlin.services.codecommit.model.Location
import aws.sdk.kotlin.services.codecommit.model.PostCommentForPullRequestResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PostCommentForPullRequestOperationDeserializer: HttpDeserializer.NonStreaming<PostCommentForPullRequestResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PostCommentForPullRequestResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPostCommentForPullRequestError(context, call, payload)
        }
        val builder = PostCommentForPullRequestResponse.Builder()

        if (payload != null) {
            deserializePostCommentForPullRequestOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPostCommentForPullRequestError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidPullRequestIdException" -> InvalidPullRequestIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommentContentRequiredException" -> CommentContentRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BeforeCommitIdAndAfterCommitIdAreSameException" -> BeforeCommitIdAndAfterCommitIdAreSameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ClientRequestTokenRequiredException" -> ClientRequestTokenRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidFilePositionException" -> InvalidFilePositionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommitIdRequiredException" -> CommitIdRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRelativeFileVersionEnumException" -> InvalidRelativeFileVersionEnumExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClientRequestTokenException" -> InvalidClientRequestTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PathRequiredException" -> PathRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IdempotencyParameterMismatchException" -> IdempotencyParameterMismatchExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCommitIdException" -> InvalidCommitIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryNotAssociatedWithPullRequestException" -> RepositoryNotAssociatedWithPullRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommitDoesNotExistException" -> CommitDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidPathException" -> InvalidPathExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PullRequestDoesNotExistException" -> PullRequestDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommentContentSizeLimitExceededException" -> CommentContentSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidFileLocationException" -> InvalidFileLocationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PullRequestIdRequiredException" -> PullRequestIdRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PathDoesNotExistException" -> PathDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePostCommentForPullRequestOperationBody(builder: PostCommentForPullRequestResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AFTERBLOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("afterBlobId"))
    val AFTERCOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("afterCommitId"))
    val BEFOREBLOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("beforeBlobId"))
    val BEFORECOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("beforeCommitId"))
    val COMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("comment"))
    val LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("location"))
    val PULLREQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("pullRequestId"))
    val REPOSITORYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("repositoryName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AFTERBLOBID_DESCRIPTOR)
        field(AFTERCOMMITID_DESCRIPTOR)
        field(BEFOREBLOBID_DESCRIPTOR)
        field(BEFORECOMMITID_DESCRIPTOR)
        field(COMMENT_DESCRIPTOR)
        field(LOCATION_DESCRIPTOR)
        field(PULLREQUESTID_DESCRIPTOR)
        field(REPOSITORYNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AFTERBLOBID_DESCRIPTOR.index -> builder.afterBlobId = deserializeString()
                AFTERCOMMITID_DESCRIPTOR.index -> builder.afterCommitId = deserializeString()
                BEFOREBLOBID_DESCRIPTOR.index -> builder.beforeBlobId = deserializeString()
                BEFORECOMMITID_DESCRIPTOR.index -> builder.beforeCommitId = deserializeString()
                COMMENT_DESCRIPTOR.index -> builder.comment = deserializeCommentDocument(deserializer)
                LOCATION_DESCRIPTOR.index -> builder.location = deserializeLocationDocument(deserializer)
                PULLREQUESTID_DESCRIPTOR.index -> builder.pullRequestId = deserializeString()
                REPOSITORYNAME_DESCRIPTOR.index -> builder.repositoryName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
