// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.ConflictMetadata
import aws.sdk.kotlin.services.codecommit.model.GetMergeConflictsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetMergeConflictsOperationDeserializer: HttpDeserializer.NonStreaming<GetMergeConflictsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetMergeConflictsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetMergeConflictsError(context, call, payload)
        }
        val builder = GetMergeConflictsResponse.Builder()

        if (payload != null) {
            deserializeGetMergeConflictsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetMergeConflictsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "MaximumItemsToCompareExceededException" -> MaximumItemsToCompareExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSourceCommitSpecifierException" -> InvalidSourceCommitSpecifierExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MergeOptionRequiredException" -> MergeOptionRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidMergeOptionException" -> InvalidMergeOptionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidMaxConflictFilesException" -> InvalidMaxConflictFilesExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCommitException" -> InvalidCommitExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDestinationCommitSpecifierException" -> InvalidDestinationCommitSpecifierExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidContinuationTokenException" -> InvalidContinuationTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MaximumFileContentToLoadExceededException" -> MaximumFileContentToLoadExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidConflictResolutionStrategyException" -> InvalidConflictResolutionStrategyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TipsDivergenceExceededException" -> TipsDivergenceExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommitRequiredException" -> CommitRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommitDoesNotExistException" -> CommitDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidConflictDetailLevelException" -> InvalidConflictDetailLevelExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMergeConflictsOperationBody(builder: GetMergeConflictsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASECOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("baseCommitId"))
    val CONFLICTMETADATALIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("conflictMetadataList"))
    val DESTINATIONCOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("destinationCommitId"))
    val MERGEABLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("mergeable"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val SOURCECOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceCommitId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASECOMMITID_DESCRIPTOR)
        field(CONFLICTMETADATALIST_DESCRIPTOR)
        field(DESTINATIONCOMMITID_DESCRIPTOR)
        field(MERGEABLE_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SOURCECOMMITID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASECOMMITID_DESCRIPTOR.index -> builder.baseCommitId = deserializeString()
                CONFLICTMETADATALIST_DESCRIPTOR.index -> builder.conflictMetadataList =
                    deserializer.deserializeList(CONFLICTMETADATALIST_DESCRIPTOR) {
                        val col0 = mutableListOf<ConflictMetadata>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeConflictMetadataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DESTINATIONCOMMITID_DESCRIPTOR.index -> builder.destinationCommitId = deserializeString()
                MERGEABLE_DESCRIPTOR.index -> builder.mergeable = deserializeBoolean()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SOURCECOMMITID_DESCRIPTOR.index -> builder.sourceCommitId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
