// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.File
import aws.sdk.kotlin.services.codecommit.model.Folder
import aws.sdk.kotlin.services.codecommit.model.GetFolderResponse
import aws.sdk.kotlin.services.codecommit.model.SubModule
import aws.sdk.kotlin.services.codecommit.model.SymbolicLink
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetFolderOperationDeserializer: HttpDeserializer.NonStreaming<GetFolderResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetFolderResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetFolderError(context, call, payload)
        }
        val builder = GetFolderResponse.Builder()

        if (payload != null) {
            deserializeGetFolderOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetFolderError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCommitException" -> InvalidCommitExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PathRequiredException" -> PathRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "FolderDoesNotExistException" -> FolderDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommitDoesNotExistException" -> CommitDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidPathException" -> InvalidPathExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetFolderOperationBody(builder: GetFolderResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("commitId"))
    val FILES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("files"))
    val FOLDERPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("folderPath"))
    val SUBFOLDERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subFolders"))
    val SUBMODULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("subModules"))
    val SYMBOLICLINKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("symbolicLinks"))
    val TREEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("treeId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMMITID_DESCRIPTOR)
        field(FILES_DESCRIPTOR)
        field(FOLDERPATH_DESCRIPTOR)
        field(SUBFOLDERS_DESCRIPTOR)
        field(SUBMODULES_DESCRIPTOR)
        field(SYMBOLICLINKS_DESCRIPTOR)
        field(TREEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMMITID_DESCRIPTOR.index -> builder.commitId = deserializeString()
                FILES_DESCRIPTOR.index -> builder.files =
                    deserializer.deserializeList(FILES_DESCRIPTOR) {
                        val col0 = mutableListOf<File>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFileDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FOLDERPATH_DESCRIPTOR.index -> builder.folderPath = deserializeString()
                SUBFOLDERS_DESCRIPTOR.index -> builder.subFolders =
                    deserializer.deserializeList(SUBFOLDERS_DESCRIPTOR) {
                        val col0 = mutableListOf<Folder>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFolderDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUBMODULES_DESCRIPTOR.index -> builder.subModules =
                    deserializer.deserializeList(SUBMODULES_DESCRIPTOR) {
                        val col0 = mutableListOf<SubModule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSubModuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SYMBOLICLINKS_DESCRIPTOR.index -> builder.symbolicLinks =
                    deserializer.deserializeList(SYMBOLICLINKS_DESCRIPTOR) {
                        val col0 = mutableListOf<SymbolicLink>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSymbolicLinkDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TREEID_DESCRIPTOR.index -> builder.treeId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
