// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.EvaluatePullRequestApprovalRulesResponse
import aws.sdk.kotlin.services.codecommit.model.Evaluation
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class EvaluatePullRequestApprovalRulesOperationDeserializer: HttpDeserializer.NonStreaming<EvaluatePullRequestApprovalRulesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): EvaluatePullRequestApprovalRulesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwEvaluatePullRequestApprovalRulesError(context, call, payload)
        }
        val builder = EvaluatePullRequestApprovalRulesResponse.Builder()

        if (payload != null) {
            deserializeEvaluatePullRequestApprovalRulesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwEvaluatePullRequestApprovalRulesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidPullRequestIdException" -> InvalidPullRequestIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RevisionIdRequiredException" -> RevisionIdRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRevisionIdException" -> InvalidRevisionIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PullRequestDoesNotExistException" -> PullRequestDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PullRequestIdRequiredException" -> PullRequestIdRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RevisionNotCurrentException" -> RevisionNotCurrentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeEvaluatePullRequestApprovalRulesOperationBody(builder: EvaluatePullRequestApprovalRulesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EVALUATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("evaluation"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EVALUATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EVALUATION_DESCRIPTOR.index -> builder.evaluation = deserializeEvaluationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
