// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.CreateCommitResponse
import aws.sdk.kotlin.services.codecommit.model.FileMetadata
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class CreateCommitOperationDeserializer: HttpDeserializer.NonStreaming<CreateCommitResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateCommitResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateCommitError(context, call, payload)
        }
        val builder = CreateCommitResponse.Builder()

        if (payload != null) {
            deserializeCreateCommitOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateCommitError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "FileDoesNotExistException" -> FileDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "FolderContentSizeLimitExceededException" -> FolderContentSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NoChangeException" -> NoChangeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "FilePathConflictsWithSubmodulePathException" -> FilePathConflictsWithSubmodulePathExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RestrictedSourceFileException" -> RestrictedSourceFileExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BranchNameIsTagNameException" -> BranchNameIsTagNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParentCommitIdException" -> InvalidParentCommitIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidBranchNameException" -> InvalidBranchNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PutFileEntryConflictException" -> PutFileEntryConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DirectoryNameConflictsWithFileNameException" -> DirectoryNameConflictsWithFileNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "FileContentSizeLimitExceededException" -> FileContentSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ParentCommitDoesNotExistException" -> ParentCommitDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ParentCommitIdOutdatedException" -> ParentCommitIdOutdatedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NameLengthExceededException" -> NameLengthExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BranchNameRequiredException" -> BranchNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PathRequiredException" -> PathRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BranchDoesNotExistException" -> BranchDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "SamePathRequestException" -> SamePathRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommitMessageLengthExceededException" -> CommitMessageLengthExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDeletionParameterException" -> InvalidDeletionParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "FileNameConflictsWithDirectoryNameException" -> FileNameConflictsWithDirectoryNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MaximumFileEntriesExceededException" -> MaximumFileEntriesExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ParentCommitIdRequiredException" -> ParentCommitIdRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidFileModeException" -> InvalidFileModeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidPathException" -> InvalidPathExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidEmailException" -> InvalidEmailExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "FileContentAndSourceFileSpecifiedException" -> FileContentAndSourceFileSpecifiedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "FileEntryRequiredException" -> FileEntryRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "FileModeRequiredException" -> FileModeRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "SourceFileOrContentRequiredException" -> SourceFileOrContentRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateCommitOperationBody(builder: CreateCommitResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("commitId"))
    val FILESADDED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("filesAdded"))
    val FILESDELETED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("filesDeleted"))
    val FILESUPDATED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("filesUpdated"))
    val TREEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("treeId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMMITID_DESCRIPTOR)
        field(FILESADDED_DESCRIPTOR)
        field(FILESDELETED_DESCRIPTOR)
        field(FILESUPDATED_DESCRIPTOR)
        field(TREEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMMITID_DESCRIPTOR.index -> builder.commitId = deserializeString()
                FILESADDED_DESCRIPTOR.index -> builder.filesAdded =
                    deserializer.deserializeList(FILESADDED_DESCRIPTOR) {
                        val col0 = mutableListOf<FileMetadata>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFileMetadataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FILESDELETED_DESCRIPTOR.index -> builder.filesDeleted =
                    deserializer.deserializeList(FILESDELETED_DESCRIPTOR) {
                        val col0 = mutableListOf<FileMetadata>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFileMetadataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FILESUPDATED_DESCRIPTOR.index -> builder.filesUpdated =
                    deserializer.deserializeList(FILESUPDATED_DESCRIPTOR) {
                        val col0 = mutableListOf<FileMetadata>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFileMetadataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TREEID_DESCRIPTOR.index -> builder.treeId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
