// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.paginators

import aws.sdk.kotlin.services.codecommit.CodeCommitClient
import aws.sdk.kotlin.services.codecommit.model.DescribeMergeConflictsRequest
import aws.sdk.kotlin.services.codecommit.model.DescribeMergeConflictsResponse
import aws.sdk.kotlin.services.codecommit.model.DescribePullRequestEventsRequest
import aws.sdk.kotlin.services.codecommit.model.DescribePullRequestEventsResponse
import aws.sdk.kotlin.services.codecommit.model.GetCommentReactionsRequest
import aws.sdk.kotlin.services.codecommit.model.GetCommentReactionsResponse
import aws.sdk.kotlin.services.codecommit.model.GetCommentsForComparedCommitRequest
import aws.sdk.kotlin.services.codecommit.model.GetCommentsForComparedCommitResponse
import aws.sdk.kotlin.services.codecommit.model.GetCommentsForPullRequestRequest
import aws.sdk.kotlin.services.codecommit.model.GetCommentsForPullRequestResponse
import aws.sdk.kotlin.services.codecommit.model.GetDifferencesRequest
import aws.sdk.kotlin.services.codecommit.model.GetDifferencesResponse
import aws.sdk.kotlin.services.codecommit.model.GetMergeConflictsRequest
import aws.sdk.kotlin.services.codecommit.model.GetMergeConflictsResponse
import aws.sdk.kotlin.services.codecommit.model.ListApprovalRuleTemplatesRequest
import aws.sdk.kotlin.services.codecommit.model.ListApprovalRuleTemplatesResponse
import aws.sdk.kotlin.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest
import aws.sdk.kotlin.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse
import aws.sdk.kotlin.services.codecommit.model.ListBranchesRequest
import aws.sdk.kotlin.services.codecommit.model.ListBranchesResponse
import aws.sdk.kotlin.services.codecommit.model.ListFileCommitHistoryRequest
import aws.sdk.kotlin.services.codecommit.model.ListFileCommitHistoryResponse
import aws.sdk.kotlin.services.codecommit.model.ListPullRequestsRequest
import aws.sdk.kotlin.services.codecommit.model.ListPullRequestsResponse
import aws.sdk.kotlin.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest
import aws.sdk.kotlin.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse
import aws.sdk.kotlin.services.codecommit.model.ListRepositoriesRequest
import aws.sdk.kotlin.services.codecommit.model.ListRepositoriesResponse
import aws.sdk.kotlin.services.codecommit.model.RepositoryNameIdPair
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeMergeConflictsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeMergeConflictsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeMergeConflictsResponse]
 */
public fun CodeCommitClient.describeMergeConflictsPaginated(initialRequest: DescribeMergeConflictsRequest): Flow<DescribeMergeConflictsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeMergeConflictsPaginated.describeMergeConflicts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeMergeConflictsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeMergeConflictsResponse]
 */
public fun CodeCommitClient.describeMergeConflictsPaginated(block: DescribeMergeConflictsRequest.Builder.() -> Unit): Flow<DescribeMergeConflictsResponse> =
    describeMergeConflictsPaginated(DescribeMergeConflictsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribePullRequestEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribePullRequestEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePullRequestEventsResponse]
 */
public fun CodeCommitClient.describePullRequestEventsPaginated(initialRequest: DescribePullRequestEventsRequest): Flow<DescribePullRequestEventsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describePullRequestEventsPaginated.describePullRequestEvents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribePullRequestEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribePullRequestEventsResponse]
 */
public fun CodeCommitClient.describePullRequestEventsPaginated(block: DescribePullRequestEventsRequest.Builder.() -> Unit): Flow<DescribePullRequestEventsResponse> =
    describePullRequestEventsPaginated(DescribePullRequestEventsRequest.Builder().apply(block).build())

/**
 * Paginate over [GetCommentReactionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetCommentReactionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCommentReactionsResponse]
 */
public fun CodeCommitClient.getCommentReactionsPaginated(initialRequest: GetCommentReactionsRequest): Flow<GetCommentReactionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getCommentReactionsPaginated.getCommentReactions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetCommentReactionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCommentReactionsResponse]
 */
public fun CodeCommitClient.getCommentReactionsPaginated(block: GetCommentReactionsRequest.Builder.() -> Unit): Flow<GetCommentReactionsResponse> =
    getCommentReactionsPaginated(GetCommentReactionsRequest.Builder().apply(block).build())

/**
 * Paginate over [GetCommentsForComparedCommitResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetCommentsForComparedCommitRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCommentsForComparedCommitResponse]
 */
public fun CodeCommitClient.getCommentsForComparedCommitPaginated(initialRequest: GetCommentsForComparedCommitRequest): Flow<GetCommentsForComparedCommitResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getCommentsForComparedCommitPaginated.getCommentsForComparedCommit(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetCommentsForComparedCommitResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCommentsForComparedCommitResponse]
 */
public fun CodeCommitClient.getCommentsForComparedCommitPaginated(block: GetCommentsForComparedCommitRequest.Builder.() -> Unit): Flow<GetCommentsForComparedCommitResponse> =
    getCommentsForComparedCommitPaginated(GetCommentsForComparedCommitRequest.Builder().apply(block).build())

/**
 * Paginate over [GetCommentsForPullRequestResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetCommentsForPullRequestRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCommentsForPullRequestResponse]
 */
public fun CodeCommitClient.getCommentsForPullRequestPaginated(initialRequest: GetCommentsForPullRequestRequest): Flow<GetCommentsForPullRequestResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getCommentsForPullRequestPaginated.getCommentsForPullRequest(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetCommentsForPullRequestResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCommentsForPullRequestResponse]
 */
public fun CodeCommitClient.getCommentsForPullRequestPaginated(block: GetCommentsForPullRequestRequest.Builder.() -> Unit): Flow<GetCommentsForPullRequestResponse> =
    getCommentsForPullRequestPaginated(GetCommentsForPullRequestRequest.Builder().apply(block).build())

/**
 * Paginate over [GetDifferencesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetDifferencesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDifferencesResponse]
 */
public fun CodeCommitClient.getDifferencesPaginated(initialRequest: GetDifferencesRequest): Flow<GetDifferencesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getDifferencesPaginated.getDifferences(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetDifferencesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDifferencesResponse]
 */
public fun CodeCommitClient.getDifferencesPaginated(block: GetDifferencesRequest.Builder.() -> Unit): Flow<GetDifferencesResponse> =
    getDifferencesPaginated(GetDifferencesRequest.Builder().apply(block).build())

/**
 * Paginate over [GetMergeConflictsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetMergeConflictsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetMergeConflictsResponse]
 */
public fun CodeCommitClient.getMergeConflictsPaginated(initialRequest: GetMergeConflictsRequest): Flow<GetMergeConflictsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getMergeConflictsPaginated.getMergeConflicts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetMergeConflictsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetMergeConflictsResponse]
 */
public fun CodeCommitClient.getMergeConflictsPaginated(block: GetMergeConflictsRequest.Builder.() -> Unit): Flow<GetMergeConflictsResponse> =
    getMergeConflictsPaginated(GetMergeConflictsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListApprovalRuleTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApprovalRuleTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApprovalRuleTemplatesResponse]
 */
public fun CodeCommitClient.listApprovalRuleTemplatesPaginated(initialRequest: ListApprovalRuleTemplatesRequest = ListApprovalRuleTemplatesRequest { }): Flow<ListApprovalRuleTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApprovalRuleTemplatesPaginated.listApprovalRuleTemplates(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApprovalRuleTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApprovalRuleTemplatesResponse]
 */
public fun CodeCommitClient.listApprovalRuleTemplatesPaginated(block: ListApprovalRuleTemplatesRequest.Builder.() -> Unit): Flow<ListApprovalRuleTemplatesResponse> =
    listApprovalRuleTemplatesPaginated(ListApprovalRuleTemplatesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAssociatedApprovalRuleTemplatesForRepositoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssociatedApprovalRuleTemplatesForRepositoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssociatedApprovalRuleTemplatesForRepositoryResponse]
 */
public fun CodeCommitClient.listAssociatedApprovalRuleTemplatesForRepositoryPaginated(initialRequest: ListAssociatedApprovalRuleTemplatesForRepositoryRequest): Flow<ListAssociatedApprovalRuleTemplatesForRepositoryResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssociatedApprovalRuleTemplatesForRepositoryPaginated.listAssociatedApprovalRuleTemplatesForRepository(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAssociatedApprovalRuleTemplatesForRepositoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssociatedApprovalRuleTemplatesForRepositoryResponse]
 */
public fun CodeCommitClient.listAssociatedApprovalRuleTemplatesForRepositoryPaginated(block: ListAssociatedApprovalRuleTemplatesForRepositoryRequest.Builder.() -> Unit): Flow<ListAssociatedApprovalRuleTemplatesForRepositoryResponse> =
    listAssociatedApprovalRuleTemplatesForRepositoryPaginated(ListAssociatedApprovalRuleTemplatesForRepositoryRequest.Builder().apply(block).build())

/**
 * Paginate over [ListBranchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBranchesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBranchesResponse]
 */
public fun CodeCommitClient.listBranchesPaginated(initialRequest: ListBranchesRequest): Flow<ListBranchesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBranchesPaginated.listBranches(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBranchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBranchesResponse]
 */
public fun CodeCommitClient.listBranchesPaginated(block: ListBranchesRequest.Builder.() -> Unit): Flow<ListBranchesResponse> =
    listBranchesPaginated(ListBranchesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBranchesPaginated]
 * to access the nested member [BranchName]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BranchName]
 */
@JvmName("listBranchesResponseBranchName")
public fun Flow<ListBranchesResponse>.branches(): Flow<String> =
    transform() { response ->
        response.branches?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFileCommitHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFileCommitHistoryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFileCommitHistoryResponse]
 */
public fun CodeCommitClient.listFileCommitHistoryPaginated(initialRequest: ListFileCommitHistoryRequest): Flow<ListFileCommitHistoryResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFileCommitHistoryPaginated.listFileCommitHistory(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFileCommitHistoryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFileCommitHistoryResponse]
 */
public fun CodeCommitClient.listFileCommitHistoryPaginated(block: ListFileCommitHistoryRequest.Builder.() -> Unit): Flow<ListFileCommitHistoryResponse> =
    listFileCommitHistoryPaginated(ListFileCommitHistoryRequest.Builder().apply(block).build())

/**
 * Paginate over [ListPullRequestsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPullRequestsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPullRequestsResponse]
 */
public fun CodeCommitClient.listPullRequestsPaginated(initialRequest: ListPullRequestsRequest): Flow<ListPullRequestsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPullRequestsPaginated.listPullRequests(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPullRequestsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPullRequestsResponse]
 */
public fun CodeCommitClient.listPullRequestsPaginated(block: ListPullRequestsRequest.Builder.() -> Unit): Flow<ListPullRequestsResponse> =
    listPullRequestsPaginated(ListPullRequestsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListRepositoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRepositoriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositoriesResponse]
 */
public fun CodeCommitClient.listRepositoriesPaginated(initialRequest: ListRepositoriesRequest = ListRepositoriesRequest { }): Flow<ListRepositoriesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRepositoriesPaginated.listRepositories(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRepositoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositoriesResponse]
 */
public fun CodeCommitClient.listRepositoriesPaginated(block: ListRepositoriesRequest.Builder.() -> Unit): Flow<ListRepositoriesResponse> =
    listRepositoriesPaginated(ListRepositoriesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRepositoriesPaginated]
 * to access the nested member [RepositoryNameIdPair]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RepositoryNameIdPair]
 */
@JvmName("listRepositoriesResponseRepositoryNameIdPair")
public fun Flow<ListRepositoriesResponse>.repositories(): Flow<RepositoryNameIdPair> =
    transform() { response ->
        response.repositories?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRepositoriesForApprovalRuleTemplateResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRepositoriesForApprovalRuleTemplateRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositoriesForApprovalRuleTemplateResponse]
 */
public fun CodeCommitClient.listRepositoriesForApprovalRuleTemplatePaginated(initialRequest: ListRepositoriesForApprovalRuleTemplateRequest): Flow<ListRepositoriesForApprovalRuleTemplateResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRepositoriesForApprovalRuleTemplatePaginated.listRepositoriesForApprovalRuleTemplate(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRepositoriesForApprovalRuleTemplateResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositoriesForApprovalRuleTemplateResponse]
 */
public fun CodeCommitClient.listRepositoriesForApprovalRuleTemplatePaginated(block: ListRepositoriesForApprovalRuleTemplateRequest.Builder.() -> Unit): Flow<ListRepositoriesForApprovalRuleTemplateResponse> =
    listRepositoriesForApprovalRuleTemplatePaginated(ListRepositoriesForApprovalRuleTemplateRequest.Builder().apply(block).build())
