// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdatePullRequestApprovalRuleContentRequest private constructor(builder: Builder) {
    /**
     * The name of the approval rule you want to update.
     */
    public val approvalRuleName: kotlin.String? = builder.approvalRuleName
    /**
     * The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using GetPullRequest.
     */
    public val existingRuleContentSha256: kotlin.String? = builder.existingRuleContentSha256
    /**
     * The updated content for the approval rule.
     *
     * When you update the content of the approval rule, you can specify approvers in an approval pool in one of two ways:
     * + **CodeCommitApprovers**: This option only requires an Amazon Web Services account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the Amazon Web Services account *123456789012* and *Mary_Major*, all of the following are counted as approvals coming from that user:
     *    + An IAM user in the account (arn:aws:iam::*123456789012*:user&#47;*Mary_Major*)
     *    + A federated user identified in IAM as Mary_Major (arn:aws:sts::*123456789012*:federated-user&#47;*Mary_Major*)
     * This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of *Mary_Major* (arn:aws:sts::*123456789012*:assumed-role/CodeCommitReview&#47;*Mary_Major*) unless you include a wildcard (*Mary_Major).
     * + **Fully qualified ARN**: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role.
     * For more information about IAM ARNs, wildcards, and formats, see [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html) in the *IAM User Guide*.
     */
    public val newRuleContent: kotlin.String? = builder.newRuleContent
    /**
     * The system-generated ID of the pull request.
     */
    public val pullRequestId: kotlin.String? = builder.pullRequestId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestApprovalRuleContentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdatePullRequestApprovalRuleContentRequest(")
        append("approvalRuleName=$approvalRuleName,")
        append("existingRuleContentSha256=$existingRuleContentSha256,")
        append("newRuleContent=$newRuleContent,")
        append("pullRequestId=$pullRequestId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = approvalRuleName?.hashCode() ?: 0
        result = 31 * result + (existingRuleContentSha256?.hashCode() ?: 0)
        result = 31 * result + (newRuleContent?.hashCode() ?: 0)
        result = 31 * result + (pullRequestId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdatePullRequestApprovalRuleContentRequest

        if (approvalRuleName != other.approvalRuleName) return false
        if (existingRuleContentSha256 != other.existingRuleContentSha256) return false
        if (newRuleContent != other.newRuleContent) return false
        if (pullRequestId != other.pullRequestId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestApprovalRuleContentRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the approval rule you want to update.
         */
        public var approvalRuleName: kotlin.String? = null
        /**
         * The SHA-256 hash signature for the content of the approval rule. You can retrieve this information by using GetPullRequest.
         */
        public var existingRuleContentSha256: kotlin.String? = null
        /**
         * The updated content for the approval rule.
         *
         * When you update the content of the approval rule, you can specify approvers in an approval pool in one of two ways:
         * + **CodeCommitApprovers**: This option only requires an Amazon Web Services account and a resource. It can be used for both IAM users and federated access users whose name matches the provided resource name. This is a very powerful option that offers a great deal of flexibility. For example, if you specify the Amazon Web Services account *123456789012* and *Mary_Major*, all of the following are counted as approvals coming from that user:
         *    + An IAM user in the account (arn:aws:iam::*123456789012*:user&#47;*Mary_Major*)
         *    + A federated user identified in IAM as Mary_Major (arn:aws:sts::*123456789012*:federated-user&#47;*Mary_Major*)
         * This option does not recognize an active session of someone assuming the role of CodeCommitReview with a role session name of *Mary_Major* (arn:aws:sts::*123456789012*:assumed-role/CodeCommitReview&#47;*Mary_Major*) unless you include a wildcard (*Mary_Major).
         * + **Fully qualified ARN**: This option allows you to specify the fully qualified Amazon Resource Name (ARN) of the IAM user or role.
         * For more information about IAM ARNs, wildcards, and formats, see [IAM Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html) in the *IAM User Guide*.
         */
        public var newRuleContent: kotlin.String? = null
        /**
         * The system-generated ID of the pull request.
         */
        public var pullRequestId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestApprovalRuleContentRequest) : this() {
            this.approvalRuleName = x.approvalRuleName
            this.existingRuleContentSha256 = x.existingRuleContentSha256
            this.newRuleContent = x.newRuleContent
            this.pullRequestId = x.pullRequestId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestApprovalRuleContentRequest = UpdatePullRequestApprovalRuleContentRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
