// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a trigger for a repository.
 *
 * If you want to receive notifications about repository events, consider using notifications instead of triggers. For more information, see [Configuring notifications for repository events](https://docs.aws.amazon.com/codecommit/latest/userguide/how-to-repository-email.html).
 */
public class RepositoryTrigger private constructor(builder: Builder) {
    /**
     * The branches to be included in the trigger configuration. If you specify an empty array, the trigger applies to all branches.
     *
     * Although no content is required in the array, you must include the array itself.
     */
    public val branches: List<String>? = builder.branches
    /**
     * Any custom data associated with the trigger to be included in the information sent to the target of the trigger.
     */
    public val customData: kotlin.String? = builder.customData
    /**
     * The ARN of the resource that is the target for a trigger (for example, the ARN of a topic in Amazon SNS).
     */
    public val destinationArn: kotlin.String = requireNotNull(builder.destinationArn) { "A non-null value must be provided for destinationArn" }
    /**
     * The repository events that cause the trigger to run actions in another service, such as sending a notification through Amazon SNS.
     *
     * The valid value "all" cannot be used with any other values.
     */
    public val events: List<RepositoryTriggerEventEnum> = requireNotNull(builder.events) { "A non-null value must be provided for events" }
    /**
     * The name of the trigger.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.RepositoryTrigger = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RepositoryTrigger(")
        append("branches=$branches,")
        append("customData=$customData,")
        append("destinationArn=$destinationArn,")
        append("events=$events,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = branches?.hashCode() ?: 0
        result = 31 * result + (customData?.hashCode() ?: 0)
        result = 31 * result + (destinationArn.hashCode())
        result = 31 * result + (events.hashCode())
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RepositoryTrigger

        if (branches != other.branches) return false
        if (customData != other.customData) return false
        if (destinationArn != other.destinationArn) return false
        if (events != other.events) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.RepositoryTrigger = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The branches to be included in the trigger configuration. If you specify an empty array, the trigger applies to all branches.
         *
         * Although no content is required in the array, you must include the array itself.
         */
        public var branches: List<String>? = null
        /**
         * Any custom data associated with the trigger to be included in the information sent to the target of the trigger.
         */
        public var customData: kotlin.String? = null
        /**
         * The ARN of the resource that is the target for a trigger (for example, the ARN of a topic in Amazon SNS).
         */
        public var destinationArn: kotlin.String? = null
        /**
         * The repository events that cause the trigger to run actions in another service, such as sending a notification through Amazon SNS.
         *
         * The valid value "all" cannot be used with any other values.
         */
        public var events: List<RepositoryTriggerEventEnum>? = null
        /**
         * The name of the trigger.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.RepositoryTrigger) : this() {
            this.branches = x.branches
            this.customData = x.customData
            this.destinationArn = x.destinationArn
            this.events = x.events
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.RepositoryTrigger = RepositoryTrigger(this)

        internal fun correctErrors(): Builder {
            if (destinationArn == null) destinationArn = ""
            if (events == null) events = emptyList()
            if (name == null) name = ""
            return this
        }
    }
}
