// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetFileResponse private constructor(builder: Builder) {
    /**
     * The blob ID of the object that represents the file content.
     */
    public val blobId: kotlin.String = requireNotNull(builder.blobId) { "A non-null value must be provided for blobId" }
    /**
     * The full commit ID of the commit that contains the content returned by GetFile.
     */
    public val commitId: kotlin.String = requireNotNull(builder.commitId) { "A non-null value must be provided for commitId" }
    /**
     * The base-64 encoded binary data object that represents the content of the file.
     */
    public val fileContent: kotlin.ByteArray = requireNotNull(builder.fileContent) { "A non-null value must be provided for fileContent" }
    /**
     * The extrapolated file mode permissions of the blob. Valid values include strings such as EXECUTABLE and not numeric values.
     *
     * The file mode permissions returned by this API are not the standard file mode permission values, such as 100644, but rather extrapolated values. See the supported return values.
     */
    public val fileMode: aws.sdk.kotlin.services.codecommit.model.FileModeTypeEnum = requireNotNull(builder.fileMode) { "A non-null value must be provided for fileMode" }
    /**
     * The fully qualified path to the specified file. Returns the name and extension of the file.
     */
    public val filePath: kotlin.String = requireNotNull(builder.filePath) { "A non-null value must be provided for filePath" }
    /**
     * The size of the contents of the file, in bytes.
     */
    public val fileSize: kotlin.Long = builder.fileSize

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.GetFileResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetFileResponse(")
        append("blobId=$blobId,")
        append("commitId=$commitId,")
        append("fileContent=$fileContent,")
        append("fileMode=$fileMode,")
        append("filePath=$filePath,")
        append("fileSize=$fileSize")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blobId.hashCode()
        result = 31 * result + (commitId.hashCode())
        result = 31 * result + (fileContent.contentHashCode())
        result = 31 * result + (fileMode.hashCode())
        result = 31 * result + (filePath.hashCode())
        result = 31 * result + (fileSize.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetFileResponse

        if (blobId != other.blobId) return false
        if (commitId != other.commitId) return false
        if (fileContent != null) {
            if (other.fileContent == null) return false
            if (!fileContent.contentEquals(other.fileContent)) return false
        } else if (other.fileContent != null) return false
        if (fileMode != other.fileMode) return false
        if (filePath != other.filePath) return false
        if (fileSize != other.fileSize) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.GetFileResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The blob ID of the object that represents the file content.
         */
        public var blobId: kotlin.String? = null
        /**
         * The full commit ID of the commit that contains the content returned by GetFile.
         */
        public var commitId: kotlin.String? = null
        /**
         * The base-64 encoded binary data object that represents the content of the file.
         */
        public var fileContent: kotlin.ByteArray? = null
        /**
         * The extrapolated file mode permissions of the blob. Valid values include strings such as EXECUTABLE and not numeric values.
         *
         * The file mode permissions returned by this API are not the standard file mode permission values, such as 100644, but rather extrapolated values. See the supported return values.
         */
        public var fileMode: aws.sdk.kotlin.services.codecommit.model.FileModeTypeEnum? = null
        /**
         * The fully qualified path to the specified file. Returns the name and extension of the file.
         */
        public var filePath: kotlin.String? = null
        /**
         * The size of the contents of the file, in bytes.
         */
        public var fileSize: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.GetFileResponse) : this() {
            this.blobId = x.blobId
            this.commitId = x.commitId
            this.fileContent = x.fileContent
            this.fileMode = x.fileMode
            this.filePath = x.filePath
            this.fileSize = x.fileSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.GetFileResponse = GetFileResponse(this)

        internal fun correctErrors(): Builder {
            if (blobId == null) blobId = ""
            if (commitId == null) commitId = ""
            if (fileContent == null) fileContent = ByteArray(0)
            if (fileMode == null) fileMode = FileModeTypeEnum.SdkUnknown("no value provided")
            if (filePath == null) filePath = ""
            return this
        }
    }
}
