// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateUnreferencedMergeCommitRequest private constructor(builder: Builder) {
    /**
     * The name of the author who created the unreferenced commit. This information is used as both the author and committer for the commit.
     */
    public val authorName: kotlin.String? = builder.authorName
    /**
     * The commit message for the unreferenced commit.
     */
    public val commitMessage: kotlin.String? = builder.commitMessage
    /**
     * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.
     */
    public val conflictDetailLevel: aws.sdk.kotlin.services.codecommit.model.ConflictDetailLevelTypeEnum? = builder.conflictDetailLevel
    /**
     * If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.
     */
    public val conflictResolution: aws.sdk.kotlin.services.codecommit.model.ConflictResolution? = builder.conflictResolution
    /**
     * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.
     */
    public val conflictResolutionStrategy: aws.sdk.kotlin.services.codecommit.model.ConflictResolutionStrategyTypeEnum? = builder.conflictResolutionStrategy
    /**
     * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).
     */
    public val destinationCommitSpecifier: kotlin.String? = builder.destinationCommitSpecifier
    /**
     * The email address for the person who created the unreferenced commit.
     */
    public val email: kotlin.String? = builder.email
    /**
     * If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.
     */
    public val keepEmptyFolders: kotlin.Boolean? = builder.keepEmptyFolders
    /**
     * The merge option or strategy you want to use to merge the code.
     */
    public val mergeOption: aws.sdk.kotlin.services.codecommit.model.MergeOptionTypeEnum? = builder.mergeOption
    /**
     * The name of the repository where you want to create the unreferenced merge commit.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName
    /**
     * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).
     */
    public val sourceCommitSpecifier: kotlin.String? = builder.sourceCommitSpecifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.CreateUnreferencedMergeCommitRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateUnreferencedMergeCommitRequest(")
        append("authorName=$authorName,")
        append("commitMessage=$commitMessage,")
        append("conflictDetailLevel=$conflictDetailLevel,")
        append("conflictResolution=$conflictResolution,")
        append("conflictResolutionStrategy=$conflictResolutionStrategy,")
        append("destinationCommitSpecifier=$destinationCommitSpecifier,")
        append("email=$email,")
        append("keepEmptyFolders=$keepEmptyFolders,")
        append("mergeOption=$mergeOption,")
        append("repositoryName=$repositoryName,")
        append("sourceCommitSpecifier=$sourceCommitSpecifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorName?.hashCode() ?: 0
        result = 31 * result + (commitMessage?.hashCode() ?: 0)
        result = 31 * result + (conflictDetailLevel?.hashCode() ?: 0)
        result = 31 * result + (conflictResolution?.hashCode() ?: 0)
        result = 31 * result + (conflictResolutionStrategy?.hashCode() ?: 0)
        result = 31 * result + (destinationCommitSpecifier?.hashCode() ?: 0)
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (keepEmptyFolders?.hashCode() ?: 0)
        result = 31 * result + (mergeOption?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        result = 31 * result + (sourceCommitSpecifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateUnreferencedMergeCommitRequest

        if (authorName != other.authorName) return false
        if (commitMessage != other.commitMessage) return false
        if (conflictDetailLevel != other.conflictDetailLevel) return false
        if (conflictResolution != other.conflictResolution) return false
        if (conflictResolutionStrategy != other.conflictResolutionStrategy) return false
        if (destinationCommitSpecifier != other.destinationCommitSpecifier) return false
        if (email != other.email) return false
        if (keepEmptyFolders != other.keepEmptyFolders) return false
        if (mergeOption != other.mergeOption) return false
        if (repositoryName != other.repositoryName) return false
        if (sourceCommitSpecifier != other.sourceCommitSpecifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.CreateUnreferencedMergeCommitRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the author who created the unreferenced commit. This information is used as both the author and committer for the commit.
         */
        public var authorName: kotlin.String? = null
        /**
         * The commit message for the unreferenced commit.
         */
        public var commitMessage: kotlin.String? = null
        /**
         * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.
         */
        public var conflictDetailLevel: aws.sdk.kotlin.services.codecommit.model.ConflictDetailLevelTypeEnum? = null
        /**
         * If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.
         */
        public var conflictResolution: aws.sdk.kotlin.services.codecommit.model.ConflictResolution? = null
        /**
         * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.
         */
        public var conflictResolutionStrategy: aws.sdk.kotlin.services.codecommit.model.ConflictResolutionStrategyTypeEnum? = null
        /**
         * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).
         */
        public var destinationCommitSpecifier: kotlin.String? = null
        /**
         * The email address for the person who created the unreferenced commit.
         */
        public var email: kotlin.String? = null
        /**
         * If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If this is specified as true, a .gitkeep file is created for empty folders. The default is false.
         */
        public var keepEmptyFolders: kotlin.Boolean? = null
        /**
         * The merge option or strategy you want to use to merge the code.
         */
        public var mergeOption: aws.sdk.kotlin.services.codecommit.model.MergeOptionTypeEnum? = null
        /**
         * The name of the repository where you want to create the unreferenced merge commit.
         */
        public var repositoryName: kotlin.String? = null
        /**
         * The branch, tag, HEAD, or other fully qualified reference used to identify a commit (for example, a branch name or a full commit ID).
         */
        public var sourceCommitSpecifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.CreateUnreferencedMergeCommitRequest) : this() {
            this.authorName = x.authorName
            this.commitMessage = x.commitMessage
            this.conflictDetailLevel = x.conflictDetailLevel
            this.conflictResolution = x.conflictResolution
            this.conflictResolutionStrategy = x.conflictResolutionStrategy
            this.destinationCommitSpecifier = x.destinationCommitSpecifier
            this.email = x.email
            this.keepEmptyFolders = x.keepEmptyFolders
            this.mergeOption = x.mergeOption
            this.repositoryName = x.repositoryName
            this.sourceCommitSpecifier = x.sourceCommitSpecifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.CreateUnreferencedMergeCommitRequest = CreateUnreferencedMergeCommitRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.ConflictResolution] inside the given [block]
         */
        public fun conflictResolution(block: aws.sdk.kotlin.services.codecommit.model.ConflictResolution.Builder.() -> kotlin.Unit) {
            this.conflictResolution = aws.sdk.kotlin.services.codecommit.model.ConflictResolution.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
