// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.UpdateRepositoryEncryptionKeyResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateRepositoryEncryptionKeyOperationDeserializer: HttpDeserialize<UpdateRepositoryEncryptionKeyResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateRepositoryEncryptionKeyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateRepositoryEncryptionKeyError(context, call)
        }
        val builder = UpdateRepositoryEncryptionKeyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateRepositoryEncryptionKeyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateRepositoryEncryptionKeyError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyRequiredException" -> EncryptionKeyRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyInvalidUsageException" -> EncryptionKeyInvalidUsageExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyInvalidIdException" -> EncryptionKeyInvalidIdExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateRepositoryEncryptionKeyOperationBody(builder: UpdateRepositoryEncryptionKeyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kmsKeyId"))
    val ORIGINALKMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("originalKmsKeyId"))
    val REPOSITORYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("repositoryId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(KMSKEYID_DESCRIPTOR)
        field(ORIGINALKMSKEYID_DESCRIPTOR)
        field(REPOSITORYID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                ORIGINALKMSKEYID_DESCRIPTOR.index -> builder.originalKmsKeyId = deserializeString()
                REPOSITORYID_DESCRIPTOR.index -> builder.repositoryId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
