// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestApprovalStateResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdatePullRequestApprovalStateOperationDeserializer: HttpDeserialize<UpdatePullRequestApprovalStateResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdatePullRequestApprovalStateResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdatePullRequestApprovalStateError(context, call)
        }
        val builder = UpdatePullRequestApprovalStateResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdatePullRequestApprovalStateError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "MaximumNumberOfApprovalsExceededException" -> MaximumNumberOfApprovalsExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidPullRequestIdException" -> InvalidPullRequestIdExceptionDeserializer().deserialize(context, wrappedCall)
        "PullRequestAlreadyClosedException" -> PullRequestAlreadyClosedExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidApprovalStateException" -> InvalidApprovalStateExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "PullRequestCannotBeApprovedByAuthorException" -> PullRequestCannotBeApprovedByAuthorExceptionDeserializer().deserialize(context, wrappedCall)
        "ApprovalStateRequiredException" -> ApprovalStateRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "RevisionIdRequiredException" -> RevisionIdRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRevisionIdException" -> InvalidRevisionIdExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall)
        "PullRequestDoesNotExistException" -> PullRequestDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "PullRequestIdRequiredException" -> PullRequestIdRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "RevisionNotCurrentException" -> RevisionNotCurrentExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
