// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.UpdateDefaultBranchResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateDefaultBranchOperationDeserializer: HttpDeserialize<UpdateDefaultBranchResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateDefaultBranchResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateDefaultBranchError(context, call)
        }
        val builder = UpdateDefaultBranchResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateDefaultBranchError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "BranchNameRequiredException" -> BranchNameRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidBranchNameException" -> InvalidBranchNameExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "BranchDoesNotExistException" -> BranchDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
