// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.ApprovalRuleTemplate
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.UpdateApprovalRuleTemplateContentResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateApprovalRuleTemplateContentOperationDeserializer: HttpDeserialize<UpdateApprovalRuleTemplateContentResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateApprovalRuleTemplateContentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateApprovalRuleTemplateContentError(context, call)
        }
        val builder = UpdateApprovalRuleTemplateContentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateApprovalRuleTemplateContentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateApprovalRuleTemplateContentError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ApprovalRuleTemplateDoesNotExistException" -> ApprovalRuleTemplateDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidApprovalRuleTemplateContentException" -> InvalidApprovalRuleTemplateContentExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRuleContentSha256Exception" -> InvalidRuleContentSha256ExceptionDeserializer().deserialize(context, wrappedCall)
        "ApprovalRuleTemplateContentRequiredException" -> ApprovalRuleTemplateContentRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "ApprovalRuleTemplateNameRequiredException" -> ApprovalRuleTemplateNameRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidApprovalRuleTemplateNameException" -> InvalidApprovalRuleTemplateNameExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateApprovalRuleTemplateContentOperationBody(builder: UpdateApprovalRuleTemplateContentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPROVALRULETEMPLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("approvalRuleTemplate"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPROVALRULETEMPLATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPROVALRULETEMPLATE_DESCRIPTOR.index -> builder.approvalRuleTemplate = deserializeApprovalRuleTemplateDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
