// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.PutRepositoryTriggersResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutRepositoryTriggersOperationDeserializer: HttpDeserialize<PutRepositoryTriggersResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PutRepositoryTriggersResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutRepositoryTriggersError(context, call)
        }
        val builder = PutRepositoryTriggersResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutRepositoryTriggersOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPutRepositoryTriggersError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRepositoryTriggerBranchNameException" -> InvalidRepositoryTriggerBranchNameExceptionDeserializer().deserialize(context, wrappedCall)
        "MaximumBranchesExceededException" -> MaximumBranchesExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRepositoryTriggerCustomDataException" -> InvalidRepositoryTriggerCustomDataExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRepositoryTriggerNameException" -> InvalidRepositoryTriggerNameExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryTriggersListRequiredException" -> RepositoryTriggersListRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryTriggerNameRequiredException" -> RepositoryTriggerNameRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryTriggerBranchNameListRequiredException" -> RepositoryTriggerBranchNameListRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryTriggerEventsListRequiredException" -> RepositoryTriggerEventsListRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRepositoryTriggerDestinationArnException" -> InvalidRepositoryTriggerDestinationArnExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRepositoryTriggerEventsException" -> InvalidRepositoryTriggerEventsExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryTriggerDestinationArnRequiredException" -> RepositoryTriggerDestinationArnRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRepositoryTriggerRegionException" -> InvalidRepositoryTriggerRegionExceptionDeserializer().deserialize(context, wrappedCall)
        "MaximumRepositoryTriggersExceededException" -> MaximumRepositoryTriggersExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutRepositoryTriggersOperationBody(builder: PutRepositoryTriggersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONFIGURATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("configurationId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONFIGURATIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONFIGURATIONID_DESCRIPTOR.index -> builder.configurationId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
