// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.FileModeTypeEnum
import aws.sdk.kotlin.services.codecommit.model.PutFileRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.encodeBase64String


internal class PutFileOperationSerializer: HttpSerialize<PutFileRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutFileRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializePutFileOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializePutFileOperationBody(context: ExecutionContext, input: PutFileRequest): ByteArray {
    val serializer = JsonSerializer()
    val BRANCHNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("branchName"))
    val COMMITMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("commitMessage"))
    val EMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("email"))
    val FILECONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("fileContent"))
    val FILEMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("fileMode"))
    val FILEPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("filePath"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PARENTCOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("parentCommitId"))
    val REPOSITORYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("repositoryName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BRANCHNAME_DESCRIPTOR)
        field(COMMITMESSAGE_DESCRIPTOR)
        field(EMAIL_DESCRIPTOR)
        field(FILECONTENT_DESCRIPTOR)
        field(FILEMODE_DESCRIPTOR)
        field(FILEPATH_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PARENTCOMMITID_DESCRIPTOR)
        field(REPOSITORYNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.branchName?.let { field(BRANCHNAME_DESCRIPTOR, it) }
        input.commitMessage?.let { field(COMMITMESSAGE_DESCRIPTOR, it) }
        input.email?.let { field(EMAIL_DESCRIPTOR, it) }
        input.fileContent?.let { field(FILECONTENT_DESCRIPTOR, it.encodeBase64String()) }
        input.fileMode?.let { field(FILEMODE_DESCRIPTOR, it.value) }
        input.filePath?.let { field(FILEPATH_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.parentCommitId?.let { field(PARENTCOMMITID_DESCRIPTOR, it) }
        input.repositoryName?.let { field(REPOSITORYNAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
