// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.PutCommentReactionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class PutCommentReactionOperationDeserializer: HttpDeserialize<PutCommentReactionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PutCommentReactionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutCommentReactionError(context, call)
        }
        val builder = PutCommentReactionResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPutCommentReactionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ReactionLimitExceededException" -> ReactionLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidCommentIdException" -> InvalidCommentIdExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidReactionValueException" -> InvalidReactionValueExceptionDeserializer().deserialize(context, wrappedCall)
        "CommentIdRequiredException" -> CommentIdRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "CommentDoesNotExistException" -> CommentDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "ReactionValueRequiredException" -> ReactionValueRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "CommentDeletedException" -> CommentDeletedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
