// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.Comment
import aws.sdk.kotlin.services.codecommit.model.PostCommentReplyResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PostCommentReplyOperationDeserializer: HttpDeserialize<PostCommentReplyResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PostCommentReplyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPostCommentReplyError(context, call)
        }
        val builder = PostCommentReplyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePostCommentReplyOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPostCommentReplyError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidCommentIdException" -> InvalidCommentIdExceptionDeserializer().deserialize(context, wrappedCall)
        "CommentContentRequiredException" -> CommentContentRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "CommentIdRequiredException" -> CommentIdRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidClientRequestTokenException" -> InvalidClientRequestTokenExceptionDeserializer().deserialize(context, wrappedCall)
        "CommentDoesNotExistException" -> CommentDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "ClientRequestTokenRequiredException" -> ClientRequestTokenRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "CommentContentSizeLimitExceededException" -> CommentContentSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "IdempotencyParameterMismatchException" -> IdempotencyParameterMismatchExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePostCommentReplyOperationBody(builder: PostCommentReplyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("comment"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMMENT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMMENT_DESCRIPTOR.index -> builder.comment = deserializeCommentDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
