// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.Comment
import aws.sdk.kotlin.services.codecommit.model.Location
import aws.sdk.kotlin.services.codecommit.model.PostCommentForPullRequestResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PostCommentForPullRequestOperationDeserializer: HttpDeserialize<PostCommentForPullRequestResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PostCommentForPullRequestResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPostCommentForPullRequestError(context, call)
        }
        val builder = PostCommentForPullRequestResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePostCommentForPullRequestOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPostCommentForPullRequestError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidPullRequestIdException" -> InvalidPullRequestIdExceptionDeserializer().deserialize(context, wrappedCall)
        "CommentContentRequiredException" -> CommentContentRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedCall)
        "BeforeCommitIdAndAfterCommitIdAreSameException" -> BeforeCommitIdAndAfterCommitIdAreSameExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall)
        "ClientRequestTokenRequiredException" -> ClientRequestTokenRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidFilePositionException" -> InvalidFilePositionExceptionDeserializer().deserialize(context, wrappedCall)
        "CommitIdRequiredException" -> CommitIdRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRelativeFileVersionEnumException" -> InvalidRelativeFileVersionEnumExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidClientRequestTokenException" -> InvalidClientRequestTokenExceptionDeserializer().deserialize(context, wrappedCall)
        "PathRequiredException" -> PathRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "IdempotencyParameterMismatchException" -> IdempotencyParameterMismatchExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidCommitIdException" -> InvalidCommitIdExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryNotAssociatedWithPullRequestException" -> RepositoryNotAssociatedWithPullRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "CommitDoesNotExistException" -> CommitDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidPathException" -> InvalidPathExceptionDeserializer().deserialize(context, wrappedCall)
        "PullRequestDoesNotExistException" -> PullRequestDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "CommentContentSizeLimitExceededException" -> CommentContentSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidFileLocationException" -> InvalidFileLocationExceptionDeserializer().deserialize(context, wrappedCall)
        "PullRequestIdRequiredException" -> PullRequestIdRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "PathDoesNotExistException" -> PathDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePostCommentForPullRequestOperationBody(builder: PostCommentForPullRequestResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AFTERBLOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("afterBlobId"))
    val AFTERCOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("afterCommitId"))
    val BEFOREBLOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("beforeBlobId"))
    val BEFORECOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("beforeCommitId"))
    val COMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("comment"))
    val LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("location"))
    val PULLREQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("pullRequestId"))
    val REPOSITORYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("repositoryName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AFTERBLOBID_DESCRIPTOR)
        field(AFTERCOMMITID_DESCRIPTOR)
        field(BEFOREBLOBID_DESCRIPTOR)
        field(BEFORECOMMITID_DESCRIPTOR)
        field(COMMENT_DESCRIPTOR)
        field(LOCATION_DESCRIPTOR)
        field(PULLREQUESTID_DESCRIPTOR)
        field(REPOSITORYNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AFTERBLOBID_DESCRIPTOR.index -> builder.afterBlobId = deserializeString()
                AFTERCOMMITID_DESCRIPTOR.index -> builder.afterCommitId = deserializeString()
                BEFOREBLOBID_DESCRIPTOR.index -> builder.beforeBlobId = deserializeString()
                BEFORECOMMITID_DESCRIPTOR.index -> builder.beforeCommitId = deserializeString()
                COMMENT_DESCRIPTOR.index -> builder.comment = deserializeCommentDocument(deserializer)
                LOCATION_DESCRIPTOR.index -> builder.location = deserializeLocationDocument(deserializer)
                PULLREQUESTID_DESCRIPTOR.index -> builder.pullRequestId = deserializeString()
                REPOSITORYNAME_DESCRIPTOR.index -> builder.repositoryName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
