// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.MergePullRequestBySquashResponse
import aws.sdk.kotlin.services.codecommit.model.PullRequest
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class MergePullRequestBySquashOperationDeserializer: HttpDeserialize<MergePullRequestBySquashResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): MergePullRequestBySquashResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwMergePullRequestBySquashError(context, call)
        }
        val builder = MergePullRequestBySquashResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeMergePullRequestBySquashOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwMergePullRequestBySquashError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "MaximumItemsToCompareExceededException" -> MaximumItemsToCompareExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "MaximumConflictResolutionEntriesExceededException" -> MaximumConflictResolutionEntriesExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "FolderContentSizeLimitExceededException" -> FolderContentSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidPullRequestIdException" -> InvalidPullRequestIdExceptionDeserializer().deserialize(context, wrappedCall)
        "TipOfSourceReferenceIsDifferentException" -> TipOfSourceReferenceIsDifferentExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidReplacementTypeException" -> InvalidReplacementTypeExceptionDeserializer().deserialize(context, wrappedCall)
        "PullRequestAlreadyClosedException" -> PullRequestAlreadyClosedExceptionDeserializer().deserialize(context, wrappedCall)
        "MaximumFileContentToLoadExceededException" -> MaximumFileContentToLoadExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedCall)
        "ConcurrentReferenceUpdateException" -> ConcurrentReferenceUpdateExceptionDeserializer().deserialize(context, wrappedCall)
        "ManualMergeRequiredException" -> ManualMergeRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidReplacementContentException" -> InvalidReplacementContentExceptionDeserializer().deserialize(context, wrappedCall)
        "ReplacementTypeRequiredException" -> ReplacementTypeRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidConflictDetailLevelException" -> InvalidConflictDetailLevelExceptionDeserializer().deserialize(context, wrappedCall)
        "FileContentSizeLimitExceededException" -> FileContentSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "NameLengthExceededException" -> NameLengthExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "PullRequestApprovalRulesNotSatisfiedException" -> PullRequestApprovalRulesNotSatisfiedExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "MultipleConflictResolutionEntriesException" -> MultipleConflictResolutionEntriesExceptionDeserializer().deserialize(context, wrappedCall)
        "PathRequiredException" -> PathRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "CommitMessageLengthExceededException" -> CommitMessageLengthExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidCommitIdException" -> InvalidCommitIdExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryNotAssociatedWithPullRequestException" -> RepositoryNotAssociatedWithPullRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidConflictResolutionStrategyException" -> InvalidConflictResolutionStrategyExceptionDeserializer().deserialize(context, wrappedCall)
        "ReplacementContentRequiredException" -> ReplacementContentRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "TipsDivergenceExceededException" -> TipsDivergenceExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidConflictResolutionException" -> InvalidConflictResolutionExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidFileModeException" -> InvalidFileModeExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidPathException" -> InvalidPathExceptionDeserializer().deserialize(context, wrappedCall)
        "PullRequestDoesNotExistException" -> PullRequestDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidEmailException" -> InvalidEmailExceptionDeserializer().deserialize(context, wrappedCall)
        "PullRequestIdRequiredException" -> PullRequestIdRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeMergePullRequestBySquashOperationBody(builder: MergePullRequestBySquashResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PULLREQUEST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("pullRequest"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PULLREQUEST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PULLREQUEST_DESCRIPTOR.index -> builder.pullRequest = deserializePullRequestDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
