// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.FileModeTypeEnum
import aws.sdk.kotlin.services.codecommit.model.GetFileResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.decodeBase64Bytes


internal class GetFileOperationDeserializer: HttpDeserialize<GetFileResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetFileResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetFileError(context, call)
        }
        val builder = GetFileResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetFileOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetFileError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "FileDoesNotExistException" -> FileDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "FileTooLargeException" -> FileTooLargeExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidCommitException" -> InvalidCommitExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "PathRequiredException" -> PathRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall)
        "CommitDoesNotExistException" -> CommitDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidPathException" -> InvalidPathExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetFileOperationBody(builder: GetFileResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BLOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("blobId"))
    val COMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("commitId"))
    val FILECONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("fileContent"))
    val FILEMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("fileMode"))
    val FILEPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("filePath"))
    val FILESIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("fileSize"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BLOBID_DESCRIPTOR)
        field(COMMITID_DESCRIPTOR)
        field(FILECONTENT_DESCRIPTOR)
        field(FILEMODE_DESCRIPTOR)
        field(FILEPATH_DESCRIPTOR)
        field(FILESIZE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BLOBID_DESCRIPTOR.index -> builder.blobId = deserializeString()
                COMMITID_DESCRIPTOR.index -> builder.commitId = deserializeString()
                FILECONTENT_DESCRIPTOR.index -> builder.fileContent = deserializeString().decodeBase64Bytes()
                FILEMODE_DESCRIPTOR.index -> builder.fileMode = deserializeString().let { FileModeTypeEnum.fromValue(it) }
                FILEPATH_DESCRIPTOR.index -> builder.filePath = deserializeString()
                FILESIZE_DESCRIPTOR.index -> builder.fileSize = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
