// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.CreateUnreferencedMergeCommitResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateUnreferencedMergeCommitOperationDeserializer: HttpDeserialize<CreateUnreferencedMergeCommitResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateUnreferencedMergeCommitResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateUnreferencedMergeCommitError(context, call)
        }
        val builder = CreateUnreferencedMergeCommitResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateUnreferencedMergeCommitOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateUnreferencedMergeCommitError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "MaximumItemsToCompareExceededException" -> MaximumItemsToCompareExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "MaximumConflictResolutionEntriesExceededException" -> MaximumConflictResolutionEntriesExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "FolderContentSizeLimitExceededException" -> FolderContentSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidMergeOptionException" -> InvalidMergeOptionExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidReplacementTypeException" -> InvalidReplacementTypeExceptionDeserializer().deserialize(context, wrappedCall)
        "MaximumFileContentToLoadExceededException" -> MaximumFileContentToLoadExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedCall)
        "ConcurrentReferenceUpdateException" -> ConcurrentReferenceUpdateExceptionDeserializer().deserialize(context, wrappedCall)
        "ManualMergeRequiredException" -> ManualMergeRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidReplacementContentException" -> InvalidReplacementContentExceptionDeserializer().deserialize(context, wrappedCall)
        "CommitRequiredException" -> CommitRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "ReplacementTypeRequiredException" -> ReplacementTypeRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidConflictDetailLevelException" -> InvalidConflictDetailLevelExceptionDeserializer().deserialize(context, wrappedCall)
        "FileContentSizeLimitExceededException" -> FileContentSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "NameLengthExceededException" -> NameLengthExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "MergeOptionRequiredException" -> MergeOptionRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "MultipleConflictResolutionEntriesException" -> MultipleConflictResolutionEntriesExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidCommitException" -> InvalidCommitExceptionDeserializer().deserialize(context, wrappedCall)
        "PathRequiredException" -> PathRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "CommitMessageLengthExceededException" -> CommitMessageLengthExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidConflictResolutionStrategyException" -> InvalidConflictResolutionStrategyExceptionDeserializer().deserialize(context, wrappedCall)
        "ReplacementContentRequiredException" -> ReplacementContentRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "TipsDivergenceExceededException" -> TipsDivergenceExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidConflictResolutionException" -> InvalidConflictResolutionExceptionDeserializer().deserialize(context, wrappedCall)
        "CommitDoesNotExistException" -> CommitDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidFileModeException" -> InvalidFileModeExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidPathException" -> InvalidPathExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidEmailException" -> InvalidEmailExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "FileModeRequiredException" -> FileModeRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateUnreferencedMergeCommitOperationBody(builder: CreateUnreferencedMergeCommitResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("commitId"))
    val TREEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("treeId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMMITID_DESCRIPTOR)
        field(TREEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMMITID_DESCRIPTOR.index -> builder.commitId = deserializeString()
                TREEID_DESCRIPTOR.index -> builder.treeId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
