// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.BatchDescribeMergeConflictsError
import aws.sdk.kotlin.services.codecommit.model.BatchDescribeMergeConflictsResponse
import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.Conflict
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchDescribeMergeConflictsOperationDeserializer: HttpDeserialize<BatchDescribeMergeConflictsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): BatchDescribeMergeConflictsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchDescribeMergeConflictsError(context, call)
        }
        val builder = BatchDescribeMergeConflictsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchDescribeMergeConflictsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwBatchDescribeMergeConflictsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "MaximumItemsToCompareExceededException" -> MaximumItemsToCompareExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "MergeOptionRequiredException" -> MergeOptionRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidMergeOptionException" -> InvalidMergeOptionExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidMaxConflictFilesException" -> InvalidMaxConflictFilesExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidCommitException" -> InvalidCommitExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidContinuationTokenException" -> InvalidContinuationTokenExceptionDeserializer().deserialize(context, wrappedCall)
        "MaximumFileContentToLoadExceededException" -> MaximumFileContentToLoadExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidMaxMergeHunksException" -> InvalidMaxMergeHunksExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidConflictResolutionStrategyException" -> InvalidConflictResolutionStrategyExceptionDeserializer().deserialize(context, wrappedCall)
        "TipsDivergenceExceededException" -> TipsDivergenceExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "CommitRequiredException" -> CommitRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall)
        "CommitDoesNotExistException" -> CommitDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidConflictDetailLevelException" -> InvalidConflictDetailLevelExceptionDeserializer().deserialize(context, wrappedCall)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchDescribeMergeConflictsOperationBody(builder: BatchDescribeMergeConflictsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASECOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("baseCommitId"))
    val CONFLICTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("conflicts"))
    val DESTINATIONCOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("destinationCommitId"))
    val ERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("errors"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val SOURCECOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceCommitId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASECOMMITID_DESCRIPTOR)
        field(CONFLICTS_DESCRIPTOR)
        field(DESTINATIONCOMMITID_DESCRIPTOR)
        field(ERRORS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SOURCECOMMITID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASECOMMITID_DESCRIPTOR.index -> builder.baseCommitId = deserializeString()
                CONFLICTS_DESCRIPTOR.index -> builder.conflicts =
                    deserializer.deserializeList(CONFLICTS_DESCRIPTOR) {
                        val col0 = mutableListOf<Conflict>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeConflictDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DESTINATIONCOMMITID_DESCRIPTOR.index -> builder.destinationCommitId = deserializeString()
                ERRORS_DESCRIPTOR.index -> builder.errors =
                    deserializer.deserializeList(ERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchDescribeMergeConflictsError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchDescribeMergeConflictsErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SOURCECOMMITID_DESCRIPTOR.index -> builder.sourceCommitId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
