// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a repository.
 */
public class RepositoryMetadata private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account associated with the repository.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) of the repository.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The URL to use for cloning the repository over HTTPS.
     */
    public val cloneUrlHttp: kotlin.String? = builder.cloneUrlHttp
    /**
     * The URL to use for cloning the repository over SSH.
     */
    public val cloneUrlSsh: kotlin.String? = builder.cloneUrlSsh
    /**
     * The date and time the repository was created, in timestamp format.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The repository's default branch name.
     */
    public val defaultBranch: kotlin.String? = builder.defaultBranch
    /**
     * The ID of the Key Management Service encryption key used to encrypt and decrypt the repository.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The date and time the repository was last modified, in timestamp format.
     */
    public val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * A comment or description about the repository.
     */
    public val repositoryDescription: kotlin.String? = builder.repositoryDescription
    /**
     * The ID of the repository.
     */
    public val repositoryId: kotlin.String? = builder.repositoryId
    /**
     * The repository's name.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.RepositoryMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RepositoryMetadata(")
        append("accountId=$accountId,")
        append("arn=$arn,")
        append("cloneUrlHttp=$cloneUrlHttp,")
        append("cloneUrlSsh=$cloneUrlSsh,")
        append("creationDate=$creationDate,")
        append("defaultBranch=$defaultBranch,")
        append("kmsKeyId=$kmsKeyId,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("repositoryDescription=$repositoryDescription,")
        append("repositoryId=$repositoryId,")
        append("repositoryName=$repositoryName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (cloneUrlHttp?.hashCode() ?: 0)
        result = 31 * result + (cloneUrlSsh?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (defaultBranch?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (repositoryDescription?.hashCode() ?: 0)
        result = 31 * result + (repositoryId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RepositoryMetadata

        if (accountId != other.accountId) return false
        if (arn != other.arn) return false
        if (cloneUrlHttp != other.cloneUrlHttp) return false
        if (cloneUrlSsh != other.cloneUrlSsh) return false
        if (creationDate != other.creationDate) return false
        if (defaultBranch != other.defaultBranch) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (repositoryDescription != other.repositoryDescription) return false
        if (repositoryId != other.repositoryId) return false
        if (repositoryName != other.repositoryName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.RepositoryMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon Web Services account associated with the repository.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the repository.
         */
        public var arn: kotlin.String? = null
        /**
         * The URL to use for cloning the repository over HTTPS.
         */
        public var cloneUrlHttp: kotlin.String? = null
        /**
         * The URL to use for cloning the repository over SSH.
         */
        public var cloneUrlSsh: kotlin.String? = null
        /**
         * The date and time the repository was created, in timestamp format.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The repository's default branch name.
         */
        public var defaultBranch: kotlin.String? = null
        /**
         * The ID of the Key Management Service encryption key used to encrypt and decrypt the repository.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The date and time the repository was last modified, in timestamp format.
         */
        public var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A comment or description about the repository.
         */
        public var repositoryDescription: kotlin.String? = null
        /**
         * The ID of the repository.
         */
        public var repositoryId: kotlin.String? = null
        /**
         * The repository's name.
         */
        public var repositoryName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.RepositoryMetadata) : this() {
            this.accountId = x.accountId
            this.arn = x.arn
            this.cloneUrlHttp = x.cloneUrlHttp
            this.cloneUrlSsh = x.cloneUrlSsh
            this.creationDate = x.creationDate
            this.defaultBranch = x.defaultBranch
            this.kmsKeyId = x.kmsKeyId
            this.lastModifiedDate = x.lastModifiedDate
            this.repositoryDescription = x.repositoryDescription
            this.repositoryId = x.repositoryId
            this.repositoryName = x.repositoryName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.RepositoryMetadata = RepositoryMetadata(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
