// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model



/**
 * Information about a replacement content entry in the conflict of a merge or pull request operation.
 */
public class ReplaceContentEntry private constructor(builder: Builder) {
    /**
     * The base-64 encoded content to use when the replacement type is USE_NEW_CONTENT.
     */
    public val content: kotlin.ByteArray? = builder.content
    /**
     * The file mode to apply during conflict resoltion.
     */
    public val fileMode: aws.sdk.kotlin.services.codecommit.model.FileModeTypeEnum? = builder.fileMode
    /**
     * The path of the conflicting file.
     */
    public val filePath: kotlin.String = requireNotNull(builder.filePath) { "A non-null value must be provided for filePath" }
    /**
     * The replacement type to use when determining how to resolve the conflict.
     */
    public val replacementType: aws.sdk.kotlin.services.codecommit.model.ReplacementTypeEnum = requireNotNull(builder.replacementType) { "A non-null value must be provided for replacementType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.ReplaceContentEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplaceContentEntry(")
        append("content=$content,")
        append("fileMode=$fileMode,")
        append("filePath=$filePath,")
        append("replacementType=$replacementType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = content?.contentHashCode() ?: 0
        result = 31 * result + (fileMode?.hashCode() ?: 0)
        result = 31 * result + (filePath.hashCode())
        result = 31 * result + (replacementType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplaceContentEntry

        if (content != null) {
            if (other.content == null) return false
            if (!content.contentEquals(other.content)) return false
        } else if (other.content != null) return false
        if (fileMode != other.fileMode) return false
        if (filePath != other.filePath) return false
        if (replacementType != other.replacementType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.ReplaceContentEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The base-64 encoded content to use when the replacement type is USE_NEW_CONTENT.
         */
        public var content: kotlin.ByteArray? = null
        /**
         * The file mode to apply during conflict resoltion.
         */
        public var fileMode: aws.sdk.kotlin.services.codecommit.model.FileModeTypeEnum? = null
        /**
         * The path of the conflicting file.
         */
        public var filePath: kotlin.String? = null
        /**
         * The replacement type to use when determining how to resolve the conflict.
         */
        public var replacementType: aws.sdk.kotlin.services.codecommit.model.ReplacementTypeEnum? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.ReplaceContentEntry) : this() {
            this.content = x.content
            this.fileMode = x.fileMode
            this.filePath = x.filePath
            this.replacementType = x.replacementType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.ReplaceContentEntry = ReplaceContentEntry(this)

        internal fun correctErrors(): Builder {
            if (filePath == null) filePath = ""
            if (replacementType == null) replacementType = ReplacementTypeEnum.SdkUnknown("no value provided")
            return this
        }
    }
}
