// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model



public class PutFileRequest private constructor(builder: Builder) {
    /**
     * The name of the branch where you want to add or update the file. If this is an empty repository, this branch is created.
     */
    public val branchName: kotlin.String? = builder.branchName
    /**
     * A message about why this file was added or updated. Although it is optional, a message makes the commit history for your repository more useful.
     */
    public val commitMessage: kotlin.String? = builder.commitMessage
    /**
     * An email address for the person adding or updating the file.
     */
    public val email: kotlin.String? = builder.email
    /**
     * The content of the file, in binary object format.
     */
    public val fileContent: kotlin.ByteArray? = builder.fileContent
    /**
     * The file mode permissions of the blob. Valid file mode permissions are listed here.
     */
    public val fileMode: aws.sdk.kotlin.services.codecommit.model.FileModeTypeEnum? = builder.fileMode
    /**
     * The name of the file you want to add or update, including the relative path to the file in the repository.
     *
     * If the path does not currently exist in the repository, the path is created as part of adding the file.
     */
    public val filePath: kotlin.String? = builder.filePath
    /**
     * The name of the person adding or updating the file. Although it is optional, a name makes the commit history for your repository more useful.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The full commit ID of the head commit in the branch where you want to add or update the file. If this is an empty repository, no commit ID is required. If this is not an empty repository, a commit ID is required.
     *
     * The commit ID must match the ID of the head commit at the time of the operation. Otherwise, an error occurs, and the file is not added or updated.
     */
    public val parentCommitId: kotlin.String? = builder.parentCommitId
    /**
     * The name of the repository where you want to add or update the file.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.PutFileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutFileRequest(")
        append("branchName=$branchName,")
        append("commitMessage=$commitMessage,")
        append("email=$email,")
        append("fileContent=$fileContent,")
        append("fileMode=$fileMode,")
        append("filePath=$filePath,")
        append("name=$name,")
        append("parentCommitId=$parentCommitId,")
        append("repositoryName=$repositoryName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = branchName?.hashCode() ?: 0
        result = 31 * result + (commitMessage?.hashCode() ?: 0)
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (fileContent?.contentHashCode() ?: 0)
        result = 31 * result + (fileMode?.hashCode() ?: 0)
        result = 31 * result + (filePath?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (parentCommitId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutFileRequest

        if (branchName != other.branchName) return false
        if (commitMessage != other.commitMessage) return false
        if (email != other.email) return false
        if (fileContent != null) {
            if (other.fileContent == null) return false
            if (!fileContent.contentEquals(other.fileContent)) return false
        } else if (other.fileContent != null) return false
        if (fileMode != other.fileMode) return false
        if (filePath != other.filePath) return false
        if (name != other.name) return false
        if (parentCommitId != other.parentCommitId) return false
        if (repositoryName != other.repositoryName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.PutFileRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the branch where you want to add or update the file. If this is an empty repository, this branch is created.
         */
        public var branchName: kotlin.String? = null
        /**
         * A message about why this file was added or updated. Although it is optional, a message makes the commit history for your repository more useful.
         */
        public var commitMessage: kotlin.String? = null
        /**
         * An email address for the person adding or updating the file.
         */
        public var email: kotlin.String? = null
        /**
         * The content of the file, in binary object format.
         */
        public var fileContent: kotlin.ByteArray? = null
        /**
         * The file mode permissions of the blob. Valid file mode permissions are listed here.
         */
        public var fileMode: aws.sdk.kotlin.services.codecommit.model.FileModeTypeEnum? = null
        /**
         * The name of the file you want to add or update, including the relative path to the file in the repository.
         *
         * If the path does not currently exist in the repository, the path is created as part of adding the file.
         */
        public var filePath: kotlin.String? = null
        /**
         * The name of the person adding or updating the file. Although it is optional, a name makes the commit history for your repository more useful.
         */
        public var name: kotlin.String? = null
        /**
         * The full commit ID of the head commit in the branch where you want to add or update the file. If this is an empty repository, no commit ID is required. If this is not an empty repository, a commit ID is required.
         *
         * The commit ID must match the ID of the head commit at the time of the operation. Otherwise, an error occurs, and the file is not added or updated.
         */
        public var parentCommitId: kotlin.String? = null
        /**
         * The name of the repository where you want to add or update the file.
         */
        public var repositoryName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.PutFileRequest) : this() {
            this.branchName = x.branchName
            this.commitMessage = x.commitMessage
            this.email = x.email
            this.fileContent = x.fileContent
            this.fileMode = x.fileMode
            this.filePath = x.filePath
            this.name = x.name
            this.parentCommitId = x.parentCommitId
            this.repositoryName = x.repositoryName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.PutFileRequest = PutFileRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
