// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model



/**
 * Returns information about a pull request target.
 */
public class PullRequestTarget private constructor(builder: Builder) {
    /**
     * The full commit ID that is the tip of the destination branch. This is the commit where the pull request was or will be merged.
     */
    public val destinationCommit: kotlin.String? = builder.destinationCommit
    /**
     * The branch of the repository where the pull request changes are merged. Also known as the destination branch.
     */
    public val destinationReference: kotlin.String? = builder.destinationReference
    /**
     * The commit ID of the most recent commit that the source branch and the destination branch have in common.
     */
    public val mergeBase: kotlin.String? = builder.mergeBase
    /**
     * Returns metadata about the state of the merge, including whether the merge has been made.
     */
    public val mergeMetadata: aws.sdk.kotlin.services.codecommit.model.MergeMetadata? = builder.mergeMetadata
    /**
     * The name of the repository that contains the pull request source and destination branches.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName
    /**
     * The full commit ID of the tip of the source branch used to create the pull request. If the pull request branch is updated by a push while the pull request is open, the commit ID changes to reflect the new tip of the branch.
     */
    public val sourceCommit: kotlin.String? = builder.sourceCommit
    /**
     * The branch of the repository that contains the changes for the pull request. Also known as the source branch.
     */
    public val sourceReference: kotlin.String? = builder.sourceReference

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.PullRequestTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PullRequestTarget(")
        append("destinationCommit=$destinationCommit,")
        append("destinationReference=$destinationReference,")
        append("mergeBase=$mergeBase,")
        append("mergeMetadata=$mergeMetadata,")
        append("repositoryName=$repositoryName,")
        append("sourceCommit=$sourceCommit,")
        append("sourceReference=$sourceReference")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationCommit?.hashCode() ?: 0
        result = 31 * result + (destinationReference?.hashCode() ?: 0)
        result = 31 * result + (mergeBase?.hashCode() ?: 0)
        result = 31 * result + (mergeMetadata?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        result = 31 * result + (sourceCommit?.hashCode() ?: 0)
        result = 31 * result + (sourceReference?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PullRequestTarget

        if (destinationCommit != other.destinationCommit) return false
        if (destinationReference != other.destinationReference) return false
        if (mergeBase != other.mergeBase) return false
        if (mergeMetadata != other.mergeMetadata) return false
        if (repositoryName != other.repositoryName) return false
        if (sourceCommit != other.sourceCommit) return false
        if (sourceReference != other.sourceReference) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.PullRequestTarget = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The full commit ID that is the tip of the destination branch. This is the commit where the pull request was or will be merged.
         */
        public var destinationCommit: kotlin.String? = null
        /**
         * The branch of the repository where the pull request changes are merged. Also known as the destination branch.
         */
        public var destinationReference: kotlin.String? = null
        /**
         * The commit ID of the most recent commit that the source branch and the destination branch have in common.
         */
        public var mergeBase: kotlin.String? = null
        /**
         * Returns metadata about the state of the merge, including whether the merge has been made.
         */
        public var mergeMetadata: aws.sdk.kotlin.services.codecommit.model.MergeMetadata? = null
        /**
         * The name of the repository that contains the pull request source and destination branches.
         */
        public var repositoryName: kotlin.String? = null
        /**
         * The full commit ID of the tip of the source branch used to create the pull request. If the pull request branch is updated by a push while the pull request is open, the commit ID changes to reflect the new tip of the branch.
         */
        public var sourceCommit: kotlin.String? = null
        /**
         * The branch of the repository that contains the changes for the pull request. Also known as the source branch.
         */
        public var sourceReference: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.PullRequestTarget) : this() {
            this.destinationCommit = x.destinationCommit
            this.destinationReference = x.destinationReference
            this.mergeBase = x.mergeBase
            this.mergeMetadata = x.mergeMetadata
            this.repositoryName = x.repositoryName
            this.sourceCommit = x.sourceCommit
            this.sourceReference = x.sourceReference
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.PullRequestTarget = PullRequestTarget(this)

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.MergeMetadata] inside the given [block]
         */
        public fun mergeMetadata(block: aws.sdk.kotlin.services.codecommit.model.MergeMetadata.Builder.() -> kotlin.Unit) {
            this.mergeMetadata = aws.sdk.kotlin.services.codecommit.model.MergeMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
