// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Returns information about a pull request.
 */
public class PullRequest private constructor(builder: Builder) {
    /**
     * The approval rules applied to the pull request.
     */
    public val approvalRules: List<ApprovalRule>? = builder.approvalRules
    /**
     * The Amazon Resource Name (ARN) of the user who created the pull request.
     */
    public val authorArn: kotlin.String? = builder.authorArn
    /**
     * A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The date and time the pull request was originally created, in timestamp format.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The user-defined description of the pull request. This description can be used to clarify what should be reviewed and other details of the request.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The day and time of the last user or system activity on the pull request, in timestamp format.
     */
    public val lastActivityDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastActivityDate
    /**
     * The system-generated ID of the pull request.
     */
    public val pullRequestId: kotlin.String? = builder.pullRequestId
    /**
     * The status of the pull request. Pull request status can only change from `OPEN` to `CLOSED`.
     */
    public val pullRequestStatus: aws.sdk.kotlin.services.codecommit.model.PullRequestStatusEnum? = builder.pullRequestStatus
    /**
     * The targets of the pull request, including the source branch and destination branch for the pull request.
     */
    public val pullRequestTargets: List<PullRequestTarget>? = builder.pullRequestTargets
    /**
     * The system-generated revision ID for the pull request.
     */
    public val revisionId: kotlin.String? = builder.revisionId
    /**
     * The user-defined title of the pull request. This title is displayed in the list of pull requests to other repository users.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.PullRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PullRequest(")
        append("approvalRules=$approvalRules,")
        append("authorArn=$authorArn,")
        append("clientRequestToken=$clientRequestToken,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("lastActivityDate=$lastActivityDate,")
        append("pullRequestId=$pullRequestId,")
        append("pullRequestStatus=$pullRequestStatus,")
        append("pullRequestTargets=$pullRequestTargets,")
        append("revisionId=$revisionId,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = approvalRules?.hashCode() ?: 0
        result = 31 * result + (authorArn?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastActivityDate?.hashCode() ?: 0)
        result = 31 * result + (pullRequestId?.hashCode() ?: 0)
        result = 31 * result + (pullRequestStatus?.hashCode() ?: 0)
        result = 31 * result + (pullRequestTargets?.hashCode() ?: 0)
        result = 31 * result + (revisionId?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PullRequest

        if (approvalRules != other.approvalRules) return false
        if (authorArn != other.authorArn) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (lastActivityDate != other.lastActivityDate) return false
        if (pullRequestId != other.pullRequestId) return false
        if (pullRequestStatus != other.pullRequestStatus) return false
        if (pullRequestTargets != other.pullRequestTargets) return false
        if (revisionId != other.revisionId) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.PullRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The approval rules applied to the pull request.
         */
        public var approvalRules: List<ApprovalRule>? = null
        /**
         * The Amazon Resource Name (ARN) of the user who created the pull request.
         */
        public var authorArn: kotlin.String? = null
        /**
         * A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The date and time the pull request was originally created, in timestamp format.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user-defined description of the pull request. This description can be used to clarify what should be reviewed and other details of the request.
         */
        public var description: kotlin.String? = null
        /**
         * The day and time of the last user or system activity on the pull request, in timestamp format.
         */
        public var lastActivityDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The system-generated ID of the pull request.
         */
        public var pullRequestId: kotlin.String? = null
        /**
         * The status of the pull request. Pull request status can only change from `OPEN` to `CLOSED`.
         */
        public var pullRequestStatus: aws.sdk.kotlin.services.codecommit.model.PullRequestStatusEnum? = null
        /**
         * The targets of the pull request, including the source branch and destination branch for the pull request.
         */
        public var pullRequestTargets: List<PullRequestTarget>? = null
        /**
         * The system-generated revision ID for the pull request.
         */
        public var revisionId: kotlin.String? = null
        /**
         * The user-defined title of the pull request. This title is displayed in the list of pull requests to other repository users.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.PullRequest) : this() {
            this.approvalRules = x.approvalRules
            this.authorArn = x.authorArn
            this.clientRequestToken = x.clientRequestToken
            this.creationDate = x.creationDate
            this.description = x.description
            this.lastActivityDate = x.lastActivityDate
            this.pullRequestId = x.pullRequestId
            this.pullRequestStatus = x.pullRequestStatus
            this.pullRequestTargets = x.pullRequestTargets
            this.revisionId = x.revisionId
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.PullRequest = PullRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
