// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model



public class MergePullRequestBySquashRequest private constructor(builder: Builder) {
    /**
     * The name of the author who created the commit. This information is used as both the author and committer for the commit.
     */
    public val authorName: kotlin.String? = builder.authorName
    /**
     * The commit message to include in the commit information for the merge.
     */
    public val commitMessage: kotlin.String? = builder.commitMessage
    /**
     * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.
     */
    public val conflictDetailLevel: aws.sdk.kotlin.services.codecommit.model.ConflictDetailLevelTypeEnum? = builder.conflictDetailLevel
    /**
     * If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.
     */
    public val conflictResolution: aws.sdk.kotlin.services.codecommit.model.ConflictResolution? = builder.conflictResolution
    /**
     * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.
     */
    public val conflictResolutionStrategy: aws.sdk.kotlin.services.codecommit.model.ConflictResolutionStrategyTypeEnum? = builder.conflictResolutionStrategy
    /**
     * The email address of the person merging the branches. This information is used in the commit information for the merge.
     */
    public val email: kotlin.String? = builder.email
    /**
     * If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.
     */
    public val keepEmptyFolders: kotlin.Boolean? = builder.keepEmptyFolders
    /**
     * The system-generated ID of the pull request. To get this ID, use ListPullRequests.
     */
    public val pullRequestId: kotlin.String? = builder.pullRequestId
    /**
     * The name of the repository where the pull request was created.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName
    /**
     * The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.
     */
    public val sourceCommitId: kotlin.String? = builder.sourceCommitId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.MergePullRequestBySquashRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MergePullRequestBySquashRequest(")
        append("authorName=$authorName,")
        append("commitMessage=$commitMessage,")
        append("conflictDetailLevel=$conflictDetailLevel,")
        append("conflictResolution=$conflictResolution,")
        append("conflictResolutionStrategy=$conflictResolutionStrategy,")
        append("email=$email,")
        append("keepEmptyFolders=$keepEmptyFolders,")
        append("pullRequestId=$pullRequestId,")
        append("repositoryName=$repositoryName,")
        append("sourceCommitId=$sourceCommitId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorName?.hashCode() ?: 0
        result = 31 * result + (commitMessage?.hashCode() ?: 0)
        result = 31 * result + (conflictDetailLevel?.hashCode() ?: 0)
        result = 31 * result + (conflictResolution?.hashCode() ?: 0)
        result = 31 * result + (conflictResolutionStrategy?.hashCode() ?: 0)
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (keepEmptyFolders?.hashCode() ?: 0)
        result = 31 * result + (pullRequestId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        result = 31 * result + (sourceCommitId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MergePullRequestBySquashRequest

        if (authorName != other.authorName) return false
        if (commitMessage != other.commitMessage) return false
        if (conflictDetailLevel != other.conflictDetailLevel) return false
        if (conflictResolution != other.conflictResolution) return false
        if (conflictResolutionStrategy != other.conflictResolutionStrategy) return false
        if (email != other.email) return false
        if (keepEmptyFolders != other.keepEmptyFolders) return false
        if (pullRequestId != other.pullRequestId) return false
        if (repositoryName != other.repositoryName) return false
        if (sourceCommitId != other.sourceCommitId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.MergePullRequestBySquashRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the author who created the commit. This information is used as both the author and committer for the commit.
         */
        public var authorName: kotlin.String? = null
        /**
         * The commit message to include in the commit information for the merge.
         */
        public var commitMessage: kotlin.String? = null
        /**
         * The level of conflict detail to use. If unspecified, the default FILE_LEVEL is used, which returns a not-mergeable result if the same file has differences in both branches. If LINE_LEVEL is specified, a conflict is considered not mergeable if the same file in both branches has differences on the same line.
         */
        public var conflictDetailLevel: aws.sdk.kotlin.services.codecommit.model.ConflictDetailLevelTypeEnum? = null
        /**
         * If AUTOMERGE is the conflict resolution strategy, a list of inputs to use when resolving conflicts during a merge.
         */
        public var conflictResolution: aws.sdk.kotlin.services.codecommit.model.ConflictResolution? = null
        /**
         * Specifies which branch to use when resolving conflicts, or whether to attempt automatically merging two versions of a file. The default is NONE, which requires any conflicts to be resolved manually before the merge operation is successful.
         */
        public var conflictResolutionStrategy: aws.sdk.kotlin.services.codecommit.model.ConflictResolutionStrategyTypeEnum? = null
        /**
         * The email address of the person merging the branches. This information is used in the commit information for the merge.
         */
        public var email: kotlin.String? = null
        /**
         * If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a .gitkeep file is created for empty folders. The default is false.
         */
        public var keepEmptyFolders: kotlin.Boolean? = null
        /**
         * The system-generated ID of the pull request. To get this ID, use ListPullRequests.
         */
        public var pullRequestId: kotlin.String? = null
        /**
         * The name of the repository where the pull request was created.
         */
        public var repositoryName: kotlin.String? = null
        /**
         * The full commit ID of the original or updated commit in the pull request source branch. Pass this value if you want an exception thrown if the current commit ID of the tip of the source branch does not match this commit ID.
         */
        public var sourceCommitId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.MergePullRequestBySquashRequest) : this() {
            this.authorName = x.authorName
            this.commitMessage = x.commitMessage
            this.conflictDetailLevel = x.conflictDetailLevel
            this.conflictResolution = x.conflictResolution
            this.conflictResolutionStrategy = x.conflictResolutionStrategy
            this.email = x.email
            this.keepEmptyFolders = x.keepEmptyFolders
            this.pullRequestId = x.pullRequestId
            this.repositoryName = x.repositoryName
            this.sourceCommitId = x.sourceCommitId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.MergePullRequestBySquashRequest = MergePullRequestBySquashRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.ConflictResolution] inside the given [block]
         */
        public fun conflictResolution(block: aws.sdk.kotlin.services.codecommit.model.ConflictResolution.Builder.() -> kotlin.Unit) {
            this.conflictResolution = aws.sdk.kotlin.services.codecommit.model.ConflictResolution.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
