// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model



public class DescribePullRequestEventsRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the pull request with more commits or changing the status of a pull request.
     */
    public val actorArn: kotlin.String? = builder.actorArn
    /**
     * A non-zero, non-negative integer used to limit the number of returned results. The default is 100 events, which is also the maximum number of events that can be returned in a result.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * An enumeration token that, when provided in a request, returns the next batch of the results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Optional. The pull request event type about which you want to return information.
     */
    public val pullRequestEventType: aws.sdk.kotlin.services.codecommit.model.PullRequestEventType? = builder.pullRequestEventType
    /**
     * The system-generated ID of the pull request. To get this ID, use ListPullRequests.
     */
    public val pullRequestId: kotlin.String? = builder.pullRequestId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.DescribePullRequestEventsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribePullRequestEventsRequest(")
        append("actorArn=$actorArn,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("pullRequestEventType=$pullRequestEventType,")
        append("pullRequestId=$pullRequestId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actorArn?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (pullRequestEventType?.hashCode() ?: 0)
        result = 31 * result + (pullRequestId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribePullRequestEventsRequest

        if (actorArn != other.actorArn) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (pullRequestEventType != other.pullRequestEventType) return false
        if (pullRequestId != other.pullRequestId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.DescribePullRequestEventsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the user whose actions resulted in the event. Examples include updating the pull request with more commits or changing the status of a pull request.
         */
        public var actorArn: kotlin.String? = null
        /**
         * A non-zero, non-negative integer used to limit the number of returned results. The default is 100 events, which is also the maximum number of events that can be returned in a result.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * An enumeration token that, when provided in a request, returns the next batch of the results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Optional. The pull request event type about which you want to return information.
         */
        public var pullRequestEventType: aws.sdk.kotlin.services.codecommit.model.PullRequestEventType? = null
        /**
         * The system-generated ID of the pull request. To get this ID, use ListPullRequests.
         */
        public var pullRequestId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.DescribePullRequestEventsRequest) : this() {
            this.actorArn = x.actorArn
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.pullRequestEventType = x.pullRequestEventType
            this.pullRequestId = x.pullRequestId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.DescribePullRequestEventsRequest = DescribePullRequestEventsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
