// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model



public class DeleteFileRequest private constructor(builder: Builder) {
    /**
     * The name of the branch where the commit that deletes the file is made.
     */
    public val branchName: kotlin.String? = builder.branchName
    /**
     * The commit message you want to include as part of deleting the file. Commit messages are limited to 256 KB. If no message is specified, a default message is used.
     */
    public val commitMessage: kotlin.String? = builder.commitMessage
    /**
     * The email address for the commit that deletes the file. If no email address is specified, the email address is left blank.
     */
    public val email: kotlin.String? = builder.email
    /**
     * The fully qualified path to the file that to be deleted, including the full name and extension of that file. For example, /examples/file.md is a fully qualified path to a file named file.md in a folder named examples.
     */
    public val filePath: kotlin.String? = builder.filePath
    /**
     * If a file is the only object in the folder or directory, specifies whether to delete the folder or directory that contains the file. By default, empty folders are deleted. This includes empty folders that are part of the directory structure. For example, if the path to a file is dir1/dir2/dir3/dir4, and dir2 and dir3 are empty, deleting the last file in dir4 also deletes the empty folders dir4, dir3, and dir2.
     */
    public val keepEmptyFolders: kotlin.Boolean? = builder.keepEmptyFolders
    /**
     * The name of the author of the commit that deletes the file. If no name is specified, the user's ARN is used as the author name and committer name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ID of the commit that is the tip of the branch where you want to create the commit that deletes the file. This must be the HEAD commit for the branch. The commit that deletes the file is created from this commit ID.
     */
    public val parentCommitId: kotlin.String? = builder.parentCommitId
    /**
     * The name of the repository that contains the file to delete.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.DeleteFileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteFileRequest(")
        append("branchName=$branchName,")
        append("commitMessage=$commitMessage,")
        append("email=$email,")
        append("filePath=$filePath,")
        append("keepEmptyFolders=$keepEmptyFolders,")
        append("name=$name,")
        append("parentCommitId=$parentCommitId,")
        append("repositoryName=$repositoryName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = branchName?.hashCode() ?: 0
        result = 31 * result + (commitMessage?.hashCode() ?: 0)
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (filePath?.hashCode() ?: 0)
        result = 31 * result + (keepEmptyFolders?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (parentCommitId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteFileRequest

        if (branchName != other.branchName) return false
        if (commitMessage != other.commitMessage) return false
        if (email != other.email) return false
        if (filePath != other.filePath) return false
        if (keepEmptyFolders != other.keepEmptyFolders) return false
        if (name != other.name) return false
        if (parentCommitId != other.parentCommitId) return false
        if (repositoryName != other.repositoryName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.DeleteFileRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the branch where the commit that deletes the file is made.
         */
        public var branchName: kotlin.String? = null
        /**
         * The commit message you want to include as part of deleting the file. Commit messages are limited to 256 KB. If no message is specified, a default message is used.
         */
        public var commitMessage: kotlin.String? = null
        /**
         * The email address for the commit that deletes the file. If no email address is specified, the email address is left blank.
         */
        public var email: kotlin.String? = null
        /**
         * The fully qualified path to the file that to be deleted, including the full name and extension of that file. For example, /examples/file.md is a fully qualified path to a file named file.md in a folder named examples.
         */
        public var filePath: kotlin.String? = null
        /**
         * If a file is the only object in the folder or directory, specifies whether to delete the folder or directory that contains the file. By default, empty folders are deleted. This includes empty folders that are part of the directory structure. For example, if the path to a file is dir1/dir2/dir3/dir4, and dir2 and dir3 are empty, deleting the last file in dir4 also deletes the empty folders dir4, dir3, and dir2.
         */
        public var keepEmptyFolders: kotlin.Boolean? = null
        /**
         * The name of the author of the commit that deletes the file. If no name is specified, the user's ARN is used as the author name and committer name.
         */
        public var name: kotlin.String? = null
        /**
         * The ID of the commit that is the tip of the branch where you want to create the commit that deletes the file. This must be the HEAD commit for the branch. The commit that deletes the file is created from this commit ID.
         */
        public var parentCommitId: kotlin.String? = null
        /**
         * The name of the repository that contains the file to delete.
         */
        public var repositoryName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.DeleteFileRequest) : this() {
            this.branchName = x.branchName
            this.commitMessage = x.commitMessage
            this.email = x.email
            this.filePath = x.filePath
            this.keepEmptyFolders = x.keepEmptyFolders
            this.name = x.name
            this.parentCommitId = x.parentCommitId
            this.repositoryName = x.repositoryName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.DeleteFileRequest = DeleteFileRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
