// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model



public class CreatePullRequestRequest private constructor(builder: Builder) {
    /**
     * A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.
     *
     * The Amazon Web ServicesSDKs prepopulate client request tokens. If you are using an Amazon Web ServicesSDK, an idempotency token is created for you.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * A description of the pull request.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The targets for the pull request, including the source of the code to be reviewed (the source branch) and the destination where the creator of the pull request intends the code to be merged after the pull request is closed (the destination branch).
     */
    public val targets: List<Target>? = builder.targets
    /**
     * The title of the pull request. This title is used to identify the pull request to other users in the repository.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.CreatePullRequestRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePullRequestRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("description=$description,")
        append("targets=$targets,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePullRequestRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (description != other.description) return false
        if (targets != other.targets) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.CreatePullRequestRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.
         *
         * The Amazon Web ServicesSDKs prepopulate client request tokens. If you are using an Amazon Web ServicesSDK, an idempotency token is created for you.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * A description of the pull request.
         */
        public var description: kotlin.String? = null
        /**
         * The targets for the pull request, including the source of the code to be reviewed (the source branch) and the destination where the creator of the pull request intends the code to be merged after the pull request is closed (the destination branch).
         */
        public var targets: List<Target>? = null
        /**
         * The title of the pull request. This title is used to identify the pull request to other users in the repository.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.CreatePullRequestRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.description = x.description
            this.targets = x.targets
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.CreatePullRequestRequest = CreatePullRequestRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
