// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model



public class CreateCommitRequest private constructor(builder: Builder) {
    /**
     * The name of the author who created the commit. This information is used as both the author and committer for the commit.
     */
    public val authorName: kotlin.String? = builder.authorName
    /**
     * The name of the branch where you create the commit.
     */
    public val branchName: kotlin.String? = builder.branchName
    /**
     * The commit message you want to include in the commit. Commit messages are limited to 256 KB. If no message is specified, a default message is used.
     */
    public val commitMessage: kotlin.String? = builder.commitMessage
    /**
     * The files to delete in this commit. These files still exist in earlier commits.
     */
    public val deleteFiles: List<DeleteFileEntry>? = builder.deleteFiles
    /**
     * The email address of the person who created the commit.
     */
    public val email: kotlin.String? = builder.email
    /**
     * If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a ..gitkeep file is created for empty folders. The default is false.
     */
    public val keepEmptyFolders: kotlin.Boolean? = builder.keepEmptyFolders
    /**
     * The ID of the commit that is the parent of the commit you create. Not required if this is an empty repository.
     */
    public val parentCommitId: kotlin.String? = builder.parentCommitId
    /**
     * The files to add or update in this commit.
     */
    public val putFiles: List<PutFileEntry>? = builder.putFiles
    /**
     * The name of the repository where you create the commit.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName
    /**
     * The file modes to update for files in this commit.
     */
    public val setFileModes: List<SetFileModeEntry>? = builder.setFileModes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.CreateCommitRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCommitRequest(")
        append("authorName=$authorName,")
        append("branchName=$branchName,")
        append("commitMessage=$commitMessage,")
        append("deleteFiles=$deleteFiles,")
        append("email=$email,")
        append("keepEmptyFolders=$keepEmptyFolders,")
        append("parentCommitId=$parentCommitId,")
        append("putFiles=$putFiles,")
        append("repositoryName=$repositoryName,")
        append("setFileModes=$setFileModes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorName?.hashCode() ?: 0
        result = 31 * result + (branchName?.hashCode() ?: 0)
        result = 31 * result + (commitMessage?.hashCode() ?: 0)
        result = 31 * result + (deleteFiles?.hashCode() ?: 0)
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (keepEmptyFolders?.hashCode() ?: 0)
        result = 31 * result + (parentCommitId?.hashCode() ?: 0)
        result = 31 * result + (putFiles?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        result = 31 * result + (setFileModes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCommitRequest

        if (authorName != other.authorName) return false
        if (branchName != other.branchName) return false
        if (commitMessage != other.commitMessage) return false
        if (deleteFiles != other.deleteFiles) return false
        if (email != other.email) return false
        if (keepEmptyFolders != other.keepEmptyFolders) return false
        if (parentCommitId != other.parentCommitId) return false
        if (putFiles != other.putFiles) return false
        if (repositoryName != other.repositoryName) return false
        if (setFileModes != other.setFileModes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.CreateCommitRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the author who created the commit. This information is used as both the author and committer for the commit.
         */
        public var authorName: kotlin.String? = null
        /**
         * The name of the branch where you create the commit.
         */
        public var branchName: kotlin.String? = null
        /**
         * The commit message you want to include in the commit. Commit messages are limited to 256 KB. If no message is specified, a default message is used.
         */
        public var commitMessage: kotlin.String? = null
        /**
         * The files to delete in this commit. These files still exist in earlier commits.
         */
        public var deleteFiles: List<DeleteFileEntry>? = null
        /**
         * The email address of the person who created the commit.
         */
        public var email: kotlin.String? = null
        /**
         * If the commit contains deletions, whether to keep a folder or folder structure if the changes leave the folders empty. If true, a ..gitkeep file is created for empty folders. The default is false.
         */
        public var keepEmptyFolders: kotlin.Boolean? = null
        /**
         * The ID of the commit that is the parent of the commit you create. Not required if this is an empty repository.
         */
        public var parentCommitId: kotlin.String? = null
        /**
         * The files to add or update in this commit.
         */
        public var putFiles: List<PutFileEntry>? = null
        /**
         * The name of the repository where you create the commit.
         */
        public var repositoryName: kotlin.String? = null
        /**
         * The file modes to update for files in this commit.
         */
        public var setFileModes: List<SetFileModeEntry>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.CreateCommitRequest) : this() {
            this.authorName = x.authorName
            this.branchName = x.branchName
            this.commitMessage = x.commitMessage
            this.deleteFiles = x.deleteFiles
            this.email = x.email
            this.keepEmptyFolders = x.keepEmptyFolders
            this.parentCommitId = x.parentCommitId
            this.putFiles = x.putFiles
            this.repositoryName = x.repositoryName
            this.setFileModes = x.setFileModes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.CreateCommitRequest = CreateCommitRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
