// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model



/**
 * Information about the metadata for a conflict in a merge operation.
 */
public class ConflictMetadata private constructor(builder: Builder) {
    /**
     * A boolean value indicating whether there are conflicts in the content of a file.
     */
    public val contentConflict: kotlin.Boolean = builder.contentConflict
    /**
     * A boolean value indicating whether there are conflicts in the file mode of a file.
     */
    public val fileModeConflict: kotlin.Boolean = builder.fileModeConflict
    /**
     * The file modes of the file in the source, destination, and base of the merge.
     */
    public val fileModes: aws.sdk.kotlin.services.codecommit.model.FileModes? = builder.fileModes
    /**
     * The path of the file that contains conflicts.
     */
    public val filePath: kotlin.String? = builder.filePath
    /**
     * The file sizes of the file in the source, destination, and base of the merge.
     */
    public val fileSizes: aws.sdk.kotlin.services.codecommit.model.FileSizes? = builder.fileSizes
    /**
     * A boolean value (true or false) indicating whether the file is binary or textual in the source, destination, and base of the merge.
     */
    public val isBinaryFile: aws.sdk.kotlin.services.codecommit.model.IsBinaryFile? = builder.isBinaryFile
    /**
     * Whether an add, modify, or delete operation caused the conflict between the source and destination of the merge.
     */
    public val mergeOperations: aws.sdk.kotlin.services.codecommit.model.MergeOperations? = builder.mergeOperations
    /**
     * The number of conflicts, including both hunk conflicts and metadata conflicts.
     */
    public val numberOfConflicts: kotlin.Int = builder.numberOfConflicts
    /**
     * A boolean value (true or false) indicating whether there are conflicts between the branches in the object type of a file, folder, or submodule.
     */
    public val objectTypeConflict: kotlin.Boolean = builder.objectTypeConflict
    /**
     * Information about any object type conflicts in a merge operation.
     */
    public val objectTypes: aws.sdk.kotlin.services.codecommit.model.ObjectTypes? = builder.objectTypes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.ConflictMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConflictMetadata(")
        append("contentConflict=$contentConflict,")
        append("fileModeConflict=$fileModeConflict,")
        append("fileModes=$fileModes,")
        append("filePath=$filePath,")
        append("fileSizes=$fileSizes,")
        append("isBinaryFile=$isBinaryFile,")
        append("mergeOperations=$mergeOperations,")
        append("numberOfConflicts=$numberOfConflicts,")
        append("objectTypeConflict=$objectTypeConflict,")
        append("objectTypes=$objectTypes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contentConflict.hashCode()
        result = 31 * result + (fileModeConflict.hashCode())
        result = 31 * result + (fileModes?.hashCode() ?: 0)
        result = 31 * result + (filePath?.hashCode() ?: 0)
        result = 31 * result + (fileSizes?.hashCode() ?: 0)
        result = 31 * result + (isBinaryFile?.hashCode() ?: 0)
        result = 31 * result + (mergeOperations?.hashCode() ?: 0)
        result = 31 * result + (numberOfConflicts)
        result = 31 * result + (objectTypeConflict.hashCode())
        result = 31 * result + (objectTypes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConflictMetadata

        if (contentConflict != other.contentConflict) return false
        if (fileModeConflict != other.fileModeConflict) return false
        if (fileModes != other.fileModes) return false
        if (filePath != other.filePath) return false
        if (fileSizes != other.fileSizes) return false
        if (isBinaryFile != other.isBinaryFile) return false
        if (mergeOperations != other.mergeOperations) return false
        if (numberOfConflicts != other.numberOfConflicts) return false
        if (objectTypeConflict != other.objectTypeConflict) return false
        if (objectTypes != other.objectTypes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.ConflictMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A boolean value indicating whether there are conflicts in the content of a file.
         */
        public var contentConflict: kotlin.Boolean = false
        /**
         * A boolean value indicating whether there are conflicts in the file mode of a file.
         */
        public var fileModeConflict: kotlin.Boolean = false
        /**
         * The file modes of the file in the source, destination, and base of the merge.
         */
        public var fileModes: aws.sdk.kotlin.services.codecommit.model.FileModes? = null
        /**
         * The path of the file that contains conflicts.
         */
        public var filePath: kotlin.String? = null
        /**
         * The file sizes of the file in the source, destination, and base of the merge.
         */
        public var fileSizes: aws.sdk.kotlin.services.codecommit.model.FileSizes? = null
        /**
         * A boolean value (true or false) indicating whether the file is binary or textual in the source, destination, and base of the merge.
         */
        public var isBinaryFile: aws.sdk.kotlin.services.codecommit.model.IsBinaryFile? = null
        /**
         * Whether an add, modify, or delete operation caused the conflict between the source and destination of the merge.
         */
        public var mergeOperations: aws.sdk.kotlin.services.codecommit.model.MergeOperations? = null
        /**
         * The number of conflicts, including both hunk conflicts and metadata conflicts.
         */
        public var numberOfConflicts: kotlin.Int = 0
        /**
         * A boolean value (true or false) indicating whether there are conflicts between the branches in the object type of a file, folder, or submodule.
         */
        public var objectTypeConflict: kotlin.Boolean = false
        /**
         * Information about any object type conflicts in a merge operation.
         */
        public var objectTypes: aws.sdk.kotlin.services.codecommit.model.ObjectTypes? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.ConflictMetadata) : this() {
            this.contentConflict = x.contentConflict
            this.fileModeConflict = x.fileModeConflict
            this.fileModes = x.fileModes
            this.filePath = x.filePath
            this.fileSizes = x.fileSizes
            this.isBinaryFile = x.isBinaryFile
            this.mergeOperations = x.mergeOperations
            this.numberOfConflicts = x.numberOfConflicts
            this.objectTypeConflict = x.objectTypeConflict
            this.objectTypes = x.objectTypes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.ConflictMetadata = ConflictMetadata(this)

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.FileModes] inside the given [block]
         */
        public fun fileModes(block: aws.sdk.kotlin.services.codecommit.model.FileModes.Builder.() -> kotlin.Unit) {
            this.fileModes = aws.sdk.kotlin.services.codecommit.model.FileModes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.FileSizes] inside the given [block]
         */
        public fun fileSizes(block: aws.sdk.kotlin.services.codecommit.model.FileSizes.Builder.() -> kotlin.Unit) {
            this.fileSizes = aws.sdk.kotlin.services.codecommit.model.FileSizes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.IsBinaryFile] inside the given [block]
         */
        public fun isBinaryFile(block: aws.sdk.kotlin.services.codecommit.model.IsBinaryFile.Builder.() -> kotlin.Unit) {
            this.isBinaryFile = aws.sdk.kotlin.services.codecommit.model.IsBinaryFile.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.MergeOperations] inside the given [block]
         */
        public fun mergeOperations(block: aws.sdk.kotlin.services.codecommit.model.MergeOperations.Builder.() -> kotlin.Unit) {
            this.mergeOperations = aws.sdk.kotlin.services.codecommit.model.MergeOperations.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.ObjectTypes] inside the given [block]
         */
        public fun objectTypes(block: aws.sdk.kotlin.services.codecommit.model.ObjectTypes.Builder.() -> kotlin.Unit) {
            this.objectTypes = aws.sdk.kotlin.services.codecommit.model.ObjectTypes.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
