// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model



/**
 * Returns information about comments on a pull request.
 */
public class CommentsForPullRequest private constructor(builder: Builder) {
    /**
     * The full blob ID of the file on which you want to comment on the source commit.
     */
    public val afterBlobId: kotlin.String? = builder.afterBlobId
    /**
     * The full commit ID of the commit that was the tip of the source branch at the time the comment was made.
     */
    public val afterCommitId: kotlin.String? = builder.afterCommitId
    /**
     * The full blob ID of the file on which you want to comment on the destination commit.
     */
    public val beforeBlobId: kotlin.String? = builder.beforeBlobId
    /**
     * The full commit ID of the commit that was the tip of the destination branch when the pull request was created. This commit is superceded by the after commit in the source branch when and if you merge the source branch into the destination branch.
     */
    public val beforeCommitId: kotlin.String? = builder.beforeCommitId
    /**
     * An array of comment objects. Each comment object contains information about a comment on the pull request.
     */
    public val comments: List<Comment>? = builder.comments
    /**
     * Location information about the comment on the pull request, including the file name, line number, and whether the version of the file where the comment was made is BEFORE (destination branch) or AFTER (source branch).
     */
    public val location: aws.sdk.kotlin.services.codecommit.model.Location? = builder.location
    /**
     * The system-generated ID of the pull request.
     */
    public val pullRequestId: kotlin.String? = builder.pullRequestId
    /**
     * The name of the repository that contains the pull request.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.CommentsForPullRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CommentsForPullRequest(")
        append("afterBlobId=$afterBlobId,")
        append("afterCommitId=$afterCommitId,")
        append("beforeBlobId=$beforeBlobId,")
        append("beforeCommitId=$beforeCommitId,")
        append("comments=$comments,")
        append("location=$location,")
        append("pullRequestId=$pullRequestId,")
        append("repositoryName=$repositoryName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = afterBlobId?.hashCode() ?: 0
        result = 31 * result + (afterCommitId?.hashCode() ?: 0)
        result = 31 * result + (beforeBlobId?.hashCode() ?: 0)
        result = 31 * result + (beforeCommitId?.hashCode() ?: 0)
        result = 31 * result + (comments?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (pullRequestId?.hashCode() ?: 0)
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CommentsForPullRequest

        if (afterBlobId != other.afterBlobId) return false
        if (afterCommitId != other.afterCommitId) return false
        if (beforeBlobId != other.beforeBlobId) return false
        if (beforeCommitId != other.beforeCommitId) return false
        if (comments != other.comments) return false
        if (location != other.location) return false
        if (pullRequestId != other.pullRequestId) return false
        if (repositoryName != other.repositoryName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.CommentsForPullRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The full blob ID of the file on which you want to comment on the source commit.
         */
        public var afterBlobId: kotlin.String? = null
        /**
         * The full commit ID of the commit that was the tip of the source branch at the time the comment was made.
         */
        public var afterCommitId: kotlin.String? = null
        /**
         * The full blob ID of the file on which you want to comment on the destination commit.
         */
        public var beforeBlobId: kotlin.String? = null
        /**
         * The full commit ID of the commit that was the tip of the destination branch when the pull request was created. This commit is superceded by the after commit in the source branch when and if you merge the source branch into the destination branch.
         */
        public var beforeCommitId: kotlin.String? = null
        /**
         * An array of comment objects. Each comment object contains information about a comment on the pull request.
         */
        public var comments: List<Comment>? = null
        /**
         * Location information about the comment on the pull request, including the file name, line number, and whether the version of the file where the comment was made is BEFORE (destination branch) or AFTER (source branch).
         */
        public var location: aws.sdk.kotlin.services.codecommit.model.Location? = null
        /**
         * The system-generated ID of the pull request.
         */
        public var pullRequestId: kotlin.String? = null
        /**
         * The name of the repository that contains the pull request.
         */
        public var repositoryName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.CommentsForPullRequest) : this() {
            this.afterBlobId = x.afterBlobId
            this.afterCommitId = x.afterCommitId
            this.beforeBlobId = x.beforeBlobId
            this.beforeCommitId = x.beforeCommitId
            this.comments = x.comments
            this.location = x.location
            this.pullRequestId = x.pullRequestId
            this.repositoryName = x.repositoryName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.CommentsForPullRequest = CommentsForPullRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codecommit.model.Location] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.codecommit.model.Location.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.codecommit.model.Location.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
