// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Returns information about a specific comment.
 */
public class Comment private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the person who posted the comment.
     */
    public val authorArn: kotlin.String? = builder.authorArn
    /**
     * The emoji reactions to a comment, if any, submitted by the user whose credentials are associated with the call to the API.
     */
    public val callerReactions: List<String>? = builder.callerReactions
    /**
     * A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The system-generated comment ID.
     */
    public val commentId: kotlin.String? = builder.commentId
    /**
     * The content of the comment.
     */
    public val content: kotlin.String? = builder.content
    /**
     * The date and time the comment was created, in timestamp format.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * A Boolean value indicating whether the comment has been deleted.
     */
    public val deleted: kotlin.Boolean = builder.deleted
    /**
     * The ID of the comment for which this comment is a reply, if any.
     */
    public val inReplyTo: kotlin.String? = builder.inReplyTo
    /**
     * The date and time the comment was most recently modified, in timestamp format.
     */
    public val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * A string to integer map that represents the number of individual users who have responded to a comment with the specified reactions.
     */
    public val reactionCounts: Map<String, Int>? = builder.reactionCounts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecommit.model.Comment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Comment(")
        append("authorArn=$authorArn,")
        append("callerReactions=$callerReactions,")
        append("clientRequestToken=$clientRequestToken,")
        append("commentId=$commentId,")
        append("content=$content,")
        append("creationDate=$creationDate,")
        append("deleted=$deleted,")
        append("inReplyTo=$inReplyTo,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("reactionCounts=$reactionCounts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorArn?.hashCode() ?: 0
        result = 31 * result + (callerReactions?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (commentId?.hashCode() ?: 0)
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (deleted.hashCode())
        result = 31 * result + (inReplyTo?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (reactionCounts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Comment

        if (authorArn != other.authorArn) return false
        if (callerReactions != other.callerReactions) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (commentId != other.commentId) return false
        if (content != other.content) return false
        if (creationDate != other.creationDate) return false
        if (deleted != other.deleted) return false
        if (inReplyTo != other.inReplyTo) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (reactionCounts != other.reactionCounts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecommit.model.Comment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the person who posted the comment.
         */
        public var authorArn: kotlin.String? = null
        /**
         * The emoji reactions to a comment, if any, submitted by the user whose credentials are associated with the call to the API.
         */
        public var callerReactions: List<String>? = null
        /**
         * A unique, client-generated idempotency token that, when provided in a request, ensures the request cannot be repeated with a changed parameter. If a request is received with the same parameters and a token is included, the request returns information about the initial request that used that token.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The system-generated comment ID.
         */
        public var commentId: kotlin.String? = null
        /**
         * The content of the comment.
         */
        public var content: kotlin.String? = null
        /**
         * The date and time the comment was created, in timestamp format.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A Boolean value indicating whether the comment has been deleted.
         */
        public var deleted: kotlin.Boolean = false
        /**
         * The ID of the comment for which this comment is a reply, if any.
         */
        public var inReplyTo: kotlin.String? = null
        /**
         * The date and time the comment was most recently modified, in timestamp format.
         */
        public var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A string to integer map that represents the number of individual users who have responded to a comment with the specified reactions.
         */
        public var reactionCounts: Map<String, Int>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecommit.model.Comment) : this() {
            this.authorArn = x.authorArn
            this.callerReactions = x.callerReactions
            this.clientRequestToken = x.clientRequestToken
            this.commentId = x.commentId
            this.content = x.content
            this.creationDate = x.creationDate
            this.deleted = x.deleted
            this.inReplyTo = x.inReplyTo
            this.lastModifiedDate = x.lastModifiedDate
            this.reactionCounts = x.reactionCounts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecommit.model.Comment = Comment(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
