// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.serde

import aws.sdk.kotlin.services.codecatalyst.model.IdeConfiguration
import aws.sdk.kotlin.services.codecatalyst.model.InstanceType
import aws.sdk.kotlin.services.codecatalyst.model.StartDevEnvironmentRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class StartDevEnvironmentOperationSerializer: HttpSerializer.NonStreaming<StartDevEnvironmentRequest> {
    override fun serialize(context: ExecutionContext, input: StartDevEnvironmentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.spaceName) { "spaceName is bound to the URI and must not be null" }
            requireNotNull(input.projectName) { "projectName is bound to the URI and must not be null" }
            requireNotNull(input.id) { "id is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("spaces"))
                add(PercentEncoding.SmithyLabel.encode(input.spaceName))
                add(PercentEncoding.Path.encode("projects"))
                add(PercentEncoding.SmithyLabel.encode(input.projectName))
                add(PercentEncoding.Path.encode("devEnvironments"))
                add(PercentEncoding.SmithyLabel.encode(input.id))
                add(PercentEncoding.Path.encode("start"))
            }
        }

        val payload = serializeStartDevEnvironmentOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartDevEnvironmentOperationBody(context: ExecutionContext, input: StartDevEnvironmentRequest): ByteArray {
    val serializer = JsonSerializer()
    val IDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ides"))
    val INACTIVITYTIMEOUTMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("inactivityTimeoutMinutes"))
    val INSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("instanceType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(IDES_DESCRIPTOR)
        field(INACTIVITYTIMEOUTMINUTES_DESCRIPTOR)
        field(INSTANCETYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.ides != null) {
            listField(IDES_DESCRIPTOR) {
                for (el0 in input.ides) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeIdeConfigurationDocument))
                }
            }
        }
        input.inactivityTimeoutMinutes?.let { field(INACTIVITYTIMEOUTMINUTES_DESCRIPTOR, it) }
        input.instanceType?.let { field(INSTANCETYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
