// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.serde

import aws.sdk.kotlin.services.codecatalyst.model.CodeCatalystException
import aws.sdk.kotlin.services.codecatalyst.model.GetSubscriptionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetSubscriptionOperationDeserializer: HttpDeserializer.NonStreaming<GetSubscriptionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetSubscriptionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetSubscriptionError(context, call, payload)
        }
        val builder = GetSubscriptionResponse.Builder()

        if (payload != null) {
            deserializeGetSubscriptionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetSubscriptionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCatalystException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeCatalystException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSubscriptionOperationBody(builder: GetSubscriptionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AWSACCOUNTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("awsAccountName"))
    val PENDINGSUBSCRIPTIONSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("pendingSubscriptionStartTime"))
    val PENDINGSUBSCRIPTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("pendingSubscriptionType"))
    val SUBSCRIPTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("subscriptionType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AWSACCOUNTNAME_DESCRIPTOR)
        field(PENDINGSUBSCRIPTIONSTARTTIME_DESCRIPTOR)
        field(PENDINGSUBSCRIPTIONTYPE_DESCRIPTOR)
        field(SUBSCRIPTIONTYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AWSACCOUNTNAME_DESCRIPTOR.index -> builder.awsAccountName = deserializeString()
                PENDINGSUBSCRIPTIONSTARTTIME_DESCRIPTOR.index -> builder.pendingSubscriptionStartTime = deserializeInstant(TimestampFormat.ISO_8601)
                PENDINGSUBSCRIPTIONTYPE_DESCRIPTOR.index -> builder.pendingSubscriptionType = deserializeString()
                SUBSCRIPTIONTYPE_DESCRIPTOR.index -> builder.subscriptionType = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
