// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a source repository returned in a list of source repositories.
 */
public class ListSourceRepositoriesItem private constructor(builder: Builder) {
    /**
     * The time the source repository was created, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdTime) { "A non-null value must be provided for createdTime" }
    /**
     * The description of the repository, if any.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The system-generated unique ID of the source repository.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The time the source repository was last updated, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedTime) { "A non-null value must be provided for lastUpdatedTime" }
    /**
     * The name of the source repository.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoriesItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSourceRepositoriesItem(")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("id=$id,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTime.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lastUpdatedTime.hashCode())
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSourceRepositoriesItem

        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoriesItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time the source repository was created, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the repository, if any.
         */
        public var description: kotlin.String? = null
        /**
         * The system-generated unique ID of the source repository.
         */
        public var id: kotlin.String? = null
        /**
         * The time the source repository was last updated, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the source repository.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoriesItem) : this() {
            this.createdTime = x.createdTime
            this.description = x.description
            this.id = x.id
            this.lastUpdatedTime = x.lastUpdatedTime
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoriesItem = ListSourceRepositoriesItem(this)

        internal fun correctErrors(): Builder {
            if (createdTime == null) createdTime = Instant.fromEpochSeconds(0)
            if (id == null) id = ""
            if (lastUpdatedTime == null) lastUpdatedTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            return this
        }
    }
}
