// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about active sessions for a Dev Environment.
 */
public class DevEnvironmentSessionSummary private constructor(builder: Builder) {
    /**
     * The system-generated unique ID of the Dev Environment.
     */
    public val devEnvironmentId: kotlin.String = requireNotNull(builder.devEnvironmentId) { "A non-null value must be provided for devEnvironmentId" }
    /**
     * The system-generated unique ID of the Dev Environment session.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The name of the project in the space.
     */
    public val projectName: kotlin.String = requireNotNull(builder.projectName) { "A non-null value must be provided for projectName" }
    /**
     * The name of the space.
     */
    public val spaceName: kotlin.String = requireNotNull(builder.spaceName) { "A non-null value must be provided for spaceName" }
    /**
     * The date and time the session started, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
     */
    public val startedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startedTime) { "A non-null value must be provided for startedTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codecatalyst.model.DevEnvironmentSessionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DevEnvironmentSessionSummary(")
        append("devEnvironmentId=$devEnvironmentId,")
        append("id=$id,")
        append("projectName=$projectName,")
        append("spaceName=$spaceName,")
        append("startedTime=$startedTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = devEnvironmentId.hashCode()
        result = 31 * result + (id.hashCode())
        result = 31 * result + (projectName.hashCode())
        result = 31 * result + (spaceName.hashCode())
        result = 31 * result + (startedTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DevEnvironmentSessionSummary

        if (devEnvironmentId != other.devEnvironmentId) return false
        if (id != other.id) return false
        if (projectName != other.projectName) return false
        if (spaceName != other.spaceName) return false
        if (startedTime != other.startedTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codecatalyst.model.DevEnvironmentSessionSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The system-generated unique ID of the Dev Environment.
         */
        public var devEnvironmentId: kotlin.String? = null
        /**
         * The system-generated unique ID of the Dev Environment session.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the project in the space.
         */
        public var projectName: kotlin.String? = null
        /**
         * The name of the space.
         */
        public var spaceName: kotlin.String? = null
        /**
         * The date and time the session started, in coordinated universal time (UTC) timestamp format as specified in [RFC 3339](https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
         */
        public var startedTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codecatalyst.model.DevEnvironmentSessionSummary) : this() {
            this.devEnvironmentId = x.devEnvironmentId
            this.id = x.id
            this.projectName = x.projectName
            this.spaceName = x.spaceName
            this.startedTime = x.startedTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codecatalyst.model.DevEnvironmentSessionSummary = DevEnvironmentSessionSummary(this)

        internal fun correctErrors(): Builder {
            if (devEnvironmentId == null) devEnvironmentId = ""
            if (id == null) id = ""
            if (projectName == null) projectName = ""
            if (spaceName == null) spaceName = ""
            if (startedTime == null) startedTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
