// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainBearerTokenProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.codecatalyst.auth.CodeCatalystAuthSchemeProvider
import aws.sdk.kotlin.services.codecatalyst.auth.DefaultCodeCatalystAuthSchemeProvider
import aws.sdk.kotlin.services.codecatalyst.endpoints.CodeCatalystEndpointParameters
import aws.sdk.kotlin.services.codecatalyst.endpoints.CodeCatalystEndpointProvider
import aws.sdk.kotlin.services.codecatalyst.endpoints.DefaultCodeCatalystEndpointProvider
import aws.sdk.kotlin.services.codecatalyst.model.CreateAccessTokenRequest
import aws.sdk.kotlin.services.codecatalyst.model.CreateAccessTokenResponse
import aws.sdk.kotlin.services.codecatalyst.model.CreateDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.CreateDevEnvironmentResponse
import aws.sdk.kotlin.services.codecatalyst.model.CreateProjectRequest
import aws.sdk.kotlin.services.codecatalyst.model.CreateProjectResponse
import aws.sdk.kotlin.services.codecatalyst.model.CreateSourceRepositoryBranchRequest
import aws.sdk.kotlin.services.codecatalyst.model.CreateSourceRepositoryBranchResponse
import aws.sdk.kotlin.services.codecatalyst.model.CreateSourceRepositoryRequest
import aws.sdk.kotlin.services.codecatalyst.model.CreateSourceRepositoryResponse
import aws.sdk.kotlin.services.codecatalyst.model.DeleteAccessTokenRequest
import aws.sdk.kotlin.services.codecatalyst.model.DeleteAccessTokenResponse
import aws.sdk.kotlin.services.codecatalyst.model.DeleteDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.DeleteDevEnvironmentResponse
import aws.sdk.kotlin.services.codecatalyst.model.DeleteProjectRequest
import aws.sdk.kotlin.services.codecatalyst.model.DeleteProjectResponse
import aws.sdk.kotlin.services.codecatalyst.model.DeleteSourceRepositoryRequest
import aws.sdk.kotlin.services.codecatalyst.model.DeleteSourceRepositoryResponse
import aws.sdk.kotlin.services.codecatalyst.model.DeleteSpaceRequest
import aws.sdk.kotlin.services.codecatalyst.model.DeleteSpaceResponse
import aws.sdk.kotlin.services.codecatalyst.model.GetDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetDevEnvironmentResponse
import aws.sdk.kotlin.services.codecatalyst.model.GetProjectRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetProjectResponse
import aws.sdk.kotlin.services.codecatalyst.model.GetSourceRepositoryCloneUrlsRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetSourceRepositoryCloneUrlsResponse
import aws.sdk.kotlin.services.codecatalyst.model.GetSourceRepositoryRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetSourceRepositoryResponse
import aws.sdk.kotlin.services.codecatalyst.model.GetSpaceRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetSpaceResponse
import aws.sdk.kotlin.services.codecatalyst.model.GetSubscriptionRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetSubscriptionResponse
import aws.sdk.kotlin.services.codecatalyst.model.GetUserDetailsRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetUserDetailsResponse
import aws.sdk.kotlin.services.codecatalyst.model.GetWorkflowRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetWorkflowResponse
import aws.sdk.kotlin.services.codecatalyst.model.GetWorkflowRunRequest
import aws.sdk.kotlin.services.codecatalyst.model.GetWorkflowRunResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListAccessTokensRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListAccessTokensResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListDevEnvironmentSessionsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListDevEnvironmentSessionsResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListDevEnvironmentsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListDevEnvironmentsResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListEventLogsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListEventLogsResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListProjectsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListProjectsResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoriesRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoriesResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoryBranchesRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListSourceRepositoryBranchesResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListSpacesRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListSpacesResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListWorkflowRunsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListWorkflowRunsResponse
import aws.sdk.kotlin.services.codecatalyst.model.ListWorkflowsRequest
import aws.sdk.kotlin.services.codecatalyst.model.ListWorkflowsResponse
import aws.sdk.kotlin.services.codecatalyst.model.StartDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.StartDevEnvironmentResponse
import aws.sdk.kotlin.services.codecatalyst.model.StartDevEnvironmentSessionRequest
import aws.sdk.kotlin.services.codecatalyst.model.StartDevEnvironmentSessionResponse
import aws.sdk.kotlin.services.codecatalyst.model.StartWorkflowRunRequest
import aws.sdk.kotlin.services.codecatalyst.model.StartWorkflowRunResponse
import aws.sdk.kotlin.services.codecatalyst.model.StopDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.StopDevEnvironmentResponse
import aws.sdk.kotlin.services.codecatalyst.model.StopDevEnvironmentSessionRequest
import aws.sdk.kotlin.services.codecatalyst.model.StopDevEnvironmentSessionResponse
import aws.sdk.kotlin.services.codecatalyst.model.UpdateDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.UpdateDevEnvironmentResponse
import aws.sdk.kotlin.services.codecatalyst.model.UpdateProjectRequest
import aws.sdk.kotlin.services.codecatalyst.model.UpdateProjectResponse
import aws.sdk.kotlin.services.codecatalyst.model.UpdateSpaceRequest
import aws.sdk.kotlin.services.codecatalyst.model.UpdateSpaceResponse
import aws.sdk.kotlin.services.codecatalyst.model.VerifySessionRequest
import aws.sdk.kotlin.services.codecatalyst.model.VerifySessionResponse
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.BearerTokenProvider
import aws.smithy.kotlin.runtime.http.auth.BearerTokenProviderConfig
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "CodeCatalyst"
public const val SdkVersion: String = "1.4.35"
public const val ServiceApiVersion: String = "2022-09-28"

/**
 * Welcome to the Amazon CodeCatalyst API reference. This reference provides descriptions of operations and data types for Amazon CodeCatalyst. You can use the Amazon CodeCatalyst API to work with the following objects.
 *
 * Spaces, by calling the following:
 * + DeleteSpace, which deletes a space.
 * + GetSpace, which returns information about a space.
 * + GetSubscription, which returns information about the Amazon Web Services account used for billing purposes and the billing plan for the space.
 * + ListSpaces, which retrieves a list of spaces.
 * + UpdateSpace, which changes one or more values for a space.
 *
 * Projects, by calling the following:
 * + CreateProject which creates a project in a specified space.
 * + GetProject, which returns information about a project.
 * + ListProjects, which retrieves a list of projects in a space.
 *
 * Users, by calling the following:
 * + GetUserDetails, which returns information about a user in Amazon CodeCatalyst.
 *
 * Source repositories, by calling the following:
 * + CreateSourceRepository, which creates an empty Git-based source repository in a specified project.
 * + CreateSourceRepositoryBranch, which creates a branch in a specified repository where you can work on code.
 * + DeleteSourceRepository, which deletes a source repository.
 * + GetSourceRepository, which returns information about a source repository.
 * + GetSourceRepositoryCloneUrls, which returns information about the URLs that can be used with a Git client to clone a source repository.
 * + ListSourceRepositories, which retrieves a list of source repositories in a project.
 * + ListSourceRepositoryBranches, which retrieves a list of branches in a source repository.
 *
 * Dev Environments and the Amazon Web Services Toolkits, by calling the following:
 * + CreateDevEnvironment, which creates a Dev Environment, where you can quickly work on the code stored in the source repositories of your project.
 * + DeleteDevEnvironment, which deletes a Dev Environment.
 * + GetDevEnvironment, which returns information about a Dev Environment.
 * + ListDevEnvironments, which retrieves a list of Dev Environments in a project.
 * + ListDevEnvironmentSessions, which retrieves a list of active Dev Environment sessions in a project.
 * + StartDevEnvironment, which starts a specified Dev Environment and puts it into an active state.
 * + StartDevEnvironmentSession, which starts a session to a specified Dev Environment.
 * + StopDevEnvironment, which stops a specified Dev Environment and puts it into an stopped state.
 * + StopDevEnvironmentSession, which stops a session for a specified Dev Environment.
 * + UpdateDevEnvironment, which changes one or more values for a Dev Environment.
 *
 * Workflows, by calling the following:
 * + GetWorkflow, which returns information about a workflow.
 * + GetWorkflowRun, which returns information about a specified run of a workflow.
 * + ListWorkflowRuns, which retrieves a list of runs of a specified workflow.
 * + ListWorkflows, which retrieves a list of workflows in a specified project.
 * + StartWorkflowRun, which starts a run of a specified workflow.
 *
 * Security, activity, and resource management in Amazon CodeCatalyst, by calling the following:
 * + CreateAccessToken, which creates a personal access token (PAT) for the current user.
 * + DeleteAccessToken, which deletes a specified personal access token (PAT).
 * + ListAccessTokens, which lists all personal access tokens (PATs) associated with a user.
 * + ListEventLogs, which retrieves a list of events that occurred during a specified time period in a space.
 * + VerifySession, which verifies whether the calling user has a valid Amazon CodeCatalyst login and session.
 *
 * If you are using the Amazon CodeCatalyst APIs with an SDK or the CLI, you must configure your computer to work with Amazon CodeCatalyst and single sign-on (SSO). For more information, see [Setting up to use the CLI with Amazon CodeCatalyst](https://docs.aws.amazon.com/codecatalyst/latest/userguide/set-up-cli.html) and the SSO documentation for your SDK.
 */
public interface CodeCatalystClient : SdkClient {
    /**
     * CodeCatalystClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CodeCatalystClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "CodeCatalyst",
                "CODECATALYST",
                "codecatalyst",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CodeCatalystClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CodeCatalystClient = DefaultCodeCatalystClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, BearerTokenProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val bearerTokenProvider: BearerTokenProvider = builder.bearerTokenProvider ?: DefaultChainBearerTokenProvider(httpClient = httpClient).manage()
        public val endpointProvider: CodeCatalystEndpointProvider = builder.endpointProvider ?: DefaultCodeCatalystEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: CodeCatalystAuthSchemeProvider = builder.authSchemeProvider ?: DefaultCodeCatalystAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            bearerTokenProvider = this@Config.bearerTokenProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, BearerTokenProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "CodeCatalyst"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The token provider to use for authenticating requests when using [aws.smithy.kotlin.runtime.http.auth.BearerTokenAuthScheme].
             * If not provided a [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainBearerTokenProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var bearerTokenProvider: BearerTokenProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: CodeCatalystEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: CodeCatalystAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a personal access token (PAT) for the current user. A personal access token (PAT) is similar to a password. It is associated with your user identity for use across all spaces and projects in Amazon CodeCatalyst. You use PATs to access CodeCatalyst from resources that include integrated development environments (IDEs) and Git-based source repositories. PATs represent you in Amazon CodeCatalyst and you can manage them in your user settings.For more information, see [Managing personal access tokens in Amazon CodeCatalyst](https://docs.aws.amazon.com/codecatalyst/latest/userguide/ipa-tokens-keys.html).
     */
    public suspend fun createAccessToken(input: CreateAccessTokenRequest): CreateAccessTokenResponse

    /**
     * Creates a Dev Environment in Amazon CodeCatalyst, a cloud-based development environment that you can use to quickly work on the code stored in the source repositories of your project.
     *
     * When created in the Amazon CodeCatalyst console, by default a Dev Environment is configured to have a 2 core processor, 4GB of RAM, and 16GB of persistent storage. None of these defaults apply to a Dev Environment created programmatically.
     */
    public suspend fun createDevEnvironment(input: CreateDevEnvironmentRequest): CreateDevEnvironmentResponse

    /**
     * Creates a project in a specified space.
     */
    public suspend fun createProject(input: CreateProjectRequest): CreateProjectResponse

    /**
     * Creates an empty Git-based source repository in a specified project. The repository is created with an initial empty commit with a default branch named `main`.
     */
    public suspend fun createSourceRepository(input: CreateSourceRepositoryRequest): CreateSourceRepositoryResponse

    /**
     * Creates a branch in a specified source repository in Amazon CodeCatalyst.
     *
     * This API only creates a branch in a source repository hosted in Amazon CodeCatalyst. You cannot use this API to create a branch in a linked repository.
     */
    public suspend fun createSourceRepositoryBranch(input: CreateSourceRepositoryBranchRequest): CreateSourceRepositoryBranchResponse

    /**
     * Deletes a specified personal access token (PAT). A personal access token can only be deleted by the user who created it.
     */
    public suspend fun deleteAccessToken(input: DeleteAccessTokenRequest): DeleteAccessTokenResponse

    /**
     * Deletes a Dev Environment.
     */
    public suspend fun deleteDevEnvironment(input: DeleteDevEnvironmentRequest): DeleteDevEnvironmentResponse

    /**
     * Deletes a project in a space.
     */
    public suspend fun deleteProject(input: DeleteProjectRequest): DeleteProjectResponse

    /**
     * Deletes a source repository in Amazon CodeCatalyst. You cannot use this API to delete a linked repository. It can only be used to delete a Amazon CodeCatalyst source repository.
     */
    public suspend fun deleteSourceRepository(input: DeleteSourceRepositoryRequest): DeleteSourceRepositoryResponse

    /**
     * Deletes a space.
     *
     * Deleting a space cannot be undone. Additionally, since space names must be unique across Amazon CodeCatalyst, you cannot reuse names of deleted spaces.
     */
    public suspend fun deleteSpace(input: DeleteSpaceRequest): DeleteSpaceResponse

    /**
     * Returns information about a Dev Environment for a source repository in a project. Dev Environments are specific to the user who creates them.
     */
    public suspend fun getDevEnvironment(input: GetDevEnvironmentRequest): GetDevEnvironmentResponse

    /**
     * Returns information about a project.
     */
    public suspend fun getProject(input: GetProjectRequest): GetProjectResponse

    /**
     * Returns information about a source repository.
     */
    public suspend fun getSourceRepository(input: GetSourceRepositoryRequest): GetSourceRepositoryResponse

    /**
     * Returns information about the URLs that can be used with a Git client to clone a source repository.
     */
    public suspend fun getSourceRepositoryCloneUrls(input: GetSourceRepositoryCloneUrlsRequest): GetSourceRepositoryCloneUrlsResponse

    /**
     * Returns information about an space.
     */
    public suspend fun getSpace(input: GetSpaceRequest): GetSpaceResponse

    /**
     * Returns information about the Amazon Web Services account used for billing purposes and the billing plan for the space.
     */
    public suspend fun getSubscription(input: GetSubscriptionRequest): GetSubscriptionResponse

    /**
     * Returns information about a user.
     */
    public suspend fun getUserDetails(input: GetUserDetailsRequest = GetUserDetailsRequest { }): GetUserDetailsResponse

    /**
     * Returns information about a workflow.
     */
    public suspend fun getWorkflow(input: GetWorkflowRequest): GetWorkflowResponse

    /**
     * Returns information about a specified run of a workflow.
     */
    public suspend fun getWorkflowRun(input: GetWorkflowRunRequest): GetWorkflowRunResponse

    /**
     * Lists all personal access tokens (PATs) associated with the user who calls the API. You can only list PATs associated with your Amazon Web Services Builder ID.
     */
    public suspend fun listAccessTokens(input: ListAccessTokensRequest = ListAccessTokensRequest { }): ListAccessTokensResponse

    /**
     * Retrieves a list of active sessions for a Dev Environment in a project.
     */
    public suspend fun listDevEnvironmentSessions(input: ListDevEnvironmentSessionsRequest): ListDevEnvironmentSessionsResponse

    /**
     * Retrieves a list of Dev Environments in a project.
     */
    public suspend fun listDevEnvironments(input: ListDevEnvironmentsRequest): ListDevEnvironmentsResponse

    /**
     * Retrieves a list of events that occurred during a specific time in a space. You can use these events to audit user and system activity in a space. For more information, see [Monitoring](https://docs.aws.amazon.com/codecatalyst/latest/userguide/ipa-monitoring.html) in the *Amazon CodeCatalyst User Guide*.
     *
     * ListEventLogs guarantees events for the last 30 days in a given space. You can also view and retrieve a list of management events over the last 90 days for Amazon CodeCatalyst in the CloudTrail console by viewing Event history, or by creating a trail to create and maintain a record of events that extends past 90 days. For more information, see [Working with CloudTrail Event History](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/view-cloudtrail-events.html) and [Working with CloudTrail trails](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-getting-started.html).
     */
    public suspend fun listEventLogs(input: ListEventLogsRequest): ListEventLogsResponse

    /**
     * Retrieves a list of projects.
     */
    public suspend fun listProjects(input: ListProjectsRequest): ListProjectsResponse

    /**
     * Retrieves a list of source repositories in a project.
     */
    public suspend fun listSourceRepositories(input: ListSourceRepositoriesRequest): ListSourceRepositoriesResponse

    /**
     * Retrieves a list of branches in a specified source repository.
     */
    public suspend fun listSourceRepositoryBranches(input: ListSourceRepositoryBranchesRequest): ListSourceRepositoryBranchesResponse

    /**
     * Retrieves a list of spaces.
     */
    public suspend fun listSpaces(input: ListSpacesRequest = ListSpacesRequest { }): ListSpacesResponse

    /**
     * Retrieves a list of workflow runs of a specified workflow.
     */
    public suspend fun listWorkflowRuns(input: ListWorkflowRunsRequest): ListWorkflowRunsResponse

    /**
     * Retrieves a list of workflows in a specified project.
     */
    public suspend fun listWorkflows(input: ListWorkflowsRequest): ListWorkflowsResponse

    /**
     * Starts a specified Dev Environment and puts it into an active state.
     */
    public suspend fun startDevEnvironment(input: StartDevEnvironmentRequest): StartDevEnvironmentResponse

    /**
     * Starts a session for a specified Dev Environment.
     */
    public suspend fun startDevEnvironmentSession(input: StartDevEnvironmentSessionRequest): StartDevEnvironmentSessionResponse

    /**
     * Begins a run of a specified workflow.
     */
    public suspend fun startWorkflowRun(input: StartWorkflowRunRequest): StartWorkflowRunResponse

    /**
     * Pauses a specified Dev Environment and places it in a non-running state. Stopped Dev Environments do not consume compute minutes.
     */
    public suspend fun stopDevEnvironment(input: StopDevEnvironmentRequest): StopDevEnvironmentResponse

    /**
     * Stops a session for a specified Dev Environment.
     */
    public suspend fun stopDevEnvironmentSession(input: StopDevEnvironmentSessionRequest): StopDevEnvironmentSessionResponse

    /**
     * Changes one or more values for a Dev Environment. Updating certain values of the Dev Environment will cause a restart.
     */
    public suspend fun updateDevEnvironment(input: UpdateDevEnvironmentRequest): UpdateDevEnvironmentResponse

    /**
     * Changes one or more values for a project.
     */
    public suspend fun updateProject(input: UpdateProjectRequest): UpdateProjectResponse

    /**
     * Changes one or more values for a space.
     */
    public suspend fun updateSpace(input: UpdateSpaceRequest): UpdateSpaceResponse

    /**
     * Verifies whether the calling user has a valid Amazon CodeCatalyst login and session. If successful, this returns the ID of the user in Amazon CodeCatalyst.
     */
    public suspend fun verifySession(input: VerifySessionRequest = VerifySessionRequest { }): VerifySessionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CodeCatalystClient.withConfig(block: CodeCatalystClient.Config.Builder.() -> Unit): CodeCatalystClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCodeCatalystClient(newConfig)
}

/**
 * Creates a personal access token (PAT) for the current user. A personal access token (PAT) is similar to a password. It is associated with your user identity for use across all spaces and projects in Amazon CodeCatalyst. You use PATs to access CodeCatalyst from resources that include integrated development environments (IDEs) and Git-based source repositories. PATs represent you in Amazon CodeCatalyst and you can manage them in your user settings.For more information, see [Managing personal access tokens in Amazon CodeCatalyst](https://docs.aws.amazon.com/codecatalyst/latest/userguide/ipa-tokens-keys.html).
 */
public suspend inline fun CodeCatalystClient.createAccessToken(crossinline block: CreateAccessTokenRequest.Builder.() -> Unit): CreateAccessTokenResponse = createAccessToken(CreateAccessTokenRequest.Builder().apply(block).build())

/**
 * Creates a Dev Environment in Amazon CodeCatalyst, a cloud-based development environment that you can use to quickly work on the code stored in the source repositories of your project.
 *
 * When created in the Amazon CodeCatalyst console, by default a Dev Environment is configured to have a 2 core processor, 4GB of RAM, and 16GB of persistent storage. None of these defaults apply to a Dev Environment created programmatically.
 */
public suspend inline fun CodeCatalystClient.createDevEnvironment(crossinline block: CreateDevEnvironmentRequest.Builder.() -> Unit): CreateDevEnvironmentResponse = createDevEnvironment(CreateDevEnvironmentRequest.Builder().apply(block).build())

/**
 * Creates a project in a specified space.
 */
public suspend inline fun CodeCatalystClient.createProject(crossinline block: CreateProjectRequest.Builder.() -> Unit): CreateProjectResponse = createProject(CreateProjectRequest.Builder().apply(block).build())

/**
 * Creates an empty Git-based source repository in a specified project. The repository is created with an initial empty commit with a default branch named `main`.
 */
public suspend inline fun CodeCatalystClient.createSourceRepository(crossinline block: CreateSourceRepositoryRequest.Builder.() -> Unit): CreateSourceRepositoryResponse = createSourceRepository(CreateSourceRepositoryRequest.Builder().apply(block).build())

/**
 * Creates a branch in a specified source repository in Amazon CodeCatalyst.
 *
 * This API only creates a branch in a source repository hosted in Amazon CodeCatalyst. You cannot use this API to create a branch in a linked repository.
 */
public suspend inline fun CodeCatalystClient.createSourceRepositoryBranch(crossinline block: CreateSourceRepositoryBranchRequest.Builder.() -> Unit): CreateSourceRepositoryBranchResponse = createSourceRepositoryBranch(CreateSourceRepositoryBranchRequest.Builder().apply(block).build())

/**
 * Deletes a specified personal access token (PAT). A personal access token can only be deleted by the user who created it.
 */
public suspend inline fun CodeCatalystClient.deleteAccessToken(crossinline block: DeleteAccessTokenRequest.Builder.() -> Unit): DeleteAccessTokenResponse = deleteAccessToken(DeleteAccessTokenRequest.Builder().apply(block).build())

/**
 * Deletes a Dev Environment.
 */
public suspend inline fun CodeCatalystClient.deleteDevEnvironment(crossinline block: DeleteDevEnvironmentRequest.Builder.() -> Unit): DeleteDevEnvironmentResponse = deleteDevEnvironment(DeleteDevEnvironmentRequest.Builder().apply(block).build())

/**
 * Deletes a project in a space.
 */
public suspend inline fun CodeCatalystClient.deleteProject(crossinline block: DeleteProjectRequest.Builder.() -> Unit): DeleteProjectResponse = deleteProject(DeleteProjectRequest.Builder().apply(block).build())

/**
 * Deletes a source repository in Amazon CodeCatalyst. You cannot use this API to delete a linked repository. It can only be used to delete a Amazon CodeCatalyst source repository.
 */
public suspend inline fun CodeCatalystClient.deleteSourceRepository(crossinline block: DeleteSourceRepositoryRequest.Builder.() -> Unit): DeleteSourceRepositoryResponse = deleteSourceRepository(DeleteSourceRepositoryRequest.Builder().apply(block).build())

/**
 * Deletes a space.
 *
 * Deleting a space cannot be undone. Additionally, since space names must be unique across Amazon CodeCatalyst, you cannot reuse names of deleted spaces.
 */
public suspend inline fun CodeCatalystClient.deleteSpace(crossinline block: DeleteSpaceRequest.Builder.() -> Unit): DeleteSpaceResponse = deleteSpace(DeleteSpaceRequest.Builder().apply(block).build())

/**
 * Returns information about a Dev Environment for a source repository in a project. Dev Environments are specific to the user who creates them.
 */
public suspend inline fun CodeCatalystClient.getDevEnvironment(crossinline block: GetDevEnvironmentRequest.Builder.() -> Unit): GetDevEnvironmentResponse = getDevEnvironment(GetDevEnvironmentRequest.Builder().apply(block).build())

/**
 * Returns information about a project.
 */
public suspend inline fun CodeCatalystClient.getProject(crossinline block: GetProjectRequest.Builder.() -> Unit): GetProjectResponse = getProject(GetProjectRequest.Builder().apply(block).build())

/**
 * Returns information about a source repository.
 */
public suspend inline fun CodeCatalystClient.getSourceRepository(crossinline block: GetSourceRepositoryRequest.Builder.() -> Unit): GetSourceRepositoryResponse = getSourceRepository(GetSourceRepositoryRequest.Builder().apply(block).build())

/**
 * Returns information about the URLs that can be used with a Git client to clone a source repository.
 */
public suspend inline fun CodeCatalystClient.getSourceRepositoryCloneUrls(crossinline block: GetSourceRepositoryCloneUrlsRequest.Builder.() -> Unit): GetSourceRepositoryCloneUrlsResponse = getSourceRepositoryCloneUrls(GetSourceRepositoryCloneUrlsRequest.Builder().apply(block).build())

/**
 * Returns information about an space.
 */
public suspend inline fun CodeCatalystClient.getSpace(crossinline block: GetSpaceRequest.Builder.() -> Unit): GetSpaceResponse = getSpace(GetSpaceRequest.Builder().apply(block).build())

/**
 * Returns information about the Amazon Web Services account used for billing purposes and the billing plan for the space.
 */
public suspend inline fun CodeCatalystClient.getSubscription(crossinline block: GetSubscriptionRequest.Builder.() -> Unit): GetSubscriptionResponse = getSubscription(GetSubscriptionRequest.Builder().apply(block).build())

/**
 * Returns information about a user.
 */
public suspend inline fun CodeCatalystClient.getUserDetails(crossinline block: GetUserDetailsRequest.Builder.() -> Unit): GetUserDetailsResponse = getUserDetails(GetUserDetailsRequest.Builder().apply(block).build())

/**
 * Returns information about a workflow.
 */
public suspend inline fun CodeCatalystClient.getWorkflow(crossinline block: GetWorkflowRequest.Builder.() -> Unit): GetWorkflowResponse = getWorkflow(GetWorkflowRequest.Builder().apply(block).build())

/**
 * Returns information about a specified run of a workflow.
 */
public suspend inline fun CodeCatalystClient.getWorkflowRun(crossinline block: GetWorkflowRunRequest.Builder.() -> Unit): GetWorkflowRunResponse = getWorkflowRun(GetWorkflowRunRequest.Builder().apply(block).build())

/**
 * Lists all personal access tokens (PATs) associated with the user who calls the API. You can only list PATs associated with your Amazon Web Services Builder ID.
 */
public suspend inline fun CodeCatalystClient.listAccessTokens(crossinline block: ListAccessTokensRequest.Builder.() -> Unit): ListAccessTokensResponse = listAccessTokens(ListAccessTokensRequest.Builder().apply(block).build())

/**
 * Retrieves a list of active sessions for a Dev Environment in a project.
 */
public suspend inline fun CodeCatalystClient.listDevEnvironmentSessions(crossinline block: ListDevEnvironmentSessionsRequest.Builder.() -> Unit): ListDevEnvironmentSessionsResponse = listDevEnvironmentSessions(ListDevEnvironmentSessionsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of Dev Environments in a project.
 */
public suspend inline fun CodeCatalystClient.listDevEnvironments(crossinline block: ListDevEnvironmentsRequest.Builder.() -> Unit): ListDevEnvironmentsResponse = listDevEnvironments(ListDevEnvironmentsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of events that occurred during a specific time in a space. You can use these events to audit user and system activity in a space. For more information, see [Monitoring](https://docs.aws.amazon.com/codecatalyst/latest/userguide/ipa-monitoring.html) in the *Amazon CodeCatalyst User Guide*.
 *
 * ListEventLogs guarantees events for the last 30 days in a given space. You can also view and retrieve a list of management events over the last 90 days for Amazon CodeCatalyst in the CloudTrail console by viewing Event history, or by creating a trail to create and maintain a record of events that extends past 90 days. For more information, see [Working with CloudTrail Event History](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/view-cloudtrail-events.html) and [Working with CloudTrail trails](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-getting-started.html).
 */
public suspend inline fun CodeCatalystClient.listEventLogs(crossinline block: ListEventLogsRequest.Builder.() -> Unit): ListEventLogsResponse = listEventLogs(ListEventLogsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of projects.
 */
public suspend inline fun CodeCatalystClient.listProjects(crossinline block: ListProjectsRequest.Builder.() -> Unit): ListProjectsResponse = listProjects(ListProjectsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of source repositories in a project.
 */
public suspend inline fun CodeCatalystClient.listSourceRepositories(crossinline block: ListSourceRepositoriesRequest.Builder.() -> Unit): ListSourceRepositoriesResponse = listSourceRepositories(ListSourceRepositoriesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of branches in a specified source repository.
 */
public suspend inline fun CodeCatalystClient.listSourceRepositoryBranches(crossinline block: ListSourceRepositoryBranchesRequest.Builder.() -> Unit): ListSourceRepositoryBranchesResponse = listSourceRepositoryBranches(ListSourceRepositoryBranchesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of spaces.
 */
public suspend inline fun CodeCatalystClient.listSpaces(crossinline block: ListSpacesRequest.Builder.() -> Unit): ListSpacesResponse = listSpaces(ListSpacesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of workflow runs of a specified workflow.
 */
public suspend inline fun CodeCatalystClient.listWorkflowRuns(crossinline block: ListWorkflowRunsRequest.Builder.() -> Unit): ListWorkflowRunsResponse = listWorkflowRuns(ListWorkflowRunsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of workflows in a specified project.
 */
public suspend inline fun CodeCatalystClient.listWorkflows(crossinline block: ListWorkflowsRequest.Builder.() -> Unit): ListWorkflowsResponse = listWorkflows(ListWorkflowsRequest.Builder().apply(block).build())

/**
 * Starts a specified Dev Environment and puts it into an active state.
 */
public suspend inline fun CodeCatalystClient.startDevEnvironment(crossinline block: StartDevEnvironmentRequest.Builder.() -> Unit): StartDevEnvironmentResponse = startDevEnvironment(StartDevEnvironmentRequest.Builder().apply(block).build())

/**
 * Starts a session for a specified Dev Environment.
 */
public suspend inline fun CodeCatalystClient.startDevEnvironmentSession(crossinline block: StartDevEnvironmentSessionRequest.Builder.() -> Unit): StartDevEnvironmentSessionResponse = startDevEnvironmentSession(StartDevEnvironmentSessionRequest.Builder().apply(block).build())

/**
 * Begins a run of a specified workflow.
 */
public suspend inline fun CodeCatalystClient.startWorkflowRun(crossinline block: StartWorkflowRunRequest.Builder.() -> Unit): StartWorkflowRunResponse = startWorkflowRun(StartWorkflowRunRequest.Builder().apply(block).build())

/**
 * Pauses a specified Dev Environment and places it in a non-running state. Stopped Dev Environments do not consume compute minutes.
 */
public suspend inline fun CodeCatalystClient.stopDevEnvironment(crossinline block: StopDevEnvironmentRequest.Builder.() -> Unit): StopDevEnvironmentResponse = stopDevEnvironment(StopDevEnvironmentRequest.Builder().apply(block).build())

/**
 * Stops a session for a specified Dev Environment.
 */
public suspend inline fun CodeCatalystClient.stopDevEnvironmentSession(crossinline block: StopDevEnvironmentSessionRequest.Builder.() -> Unit): StopDevEnvironmentSessionResponse = stopDevEnvironmentSession(StopDevEnvironmentSessionRequest.Builder().apply(block).build())

/**
 * Changes one or more values for a Dev Environment. Updating certain values of the Dev Environment will cause a restart.
 */
public suspend inline fun CodeCatalystClient.updateDevEnvironment(crossinline block: UpdateDevEnvironmentRequest.Builder.() -> Unit): UpdateDevEnvironmentResponse = updateDevEnvironment(UpdateDevEnvironmentRequest.Builder().apply(block).build())

/**
 * Changes one or more values for a project.
 */
public suspend inline fun CodeCatalystClient.updateProject(crossinline block: UpdateProjectRequest.Builder.() -> Unit): UpdateProjectResponse = updateProject(UpdateProjectRequest.Builder().apply(block).build())

/**
 * Changes one or more values for a space.
 */
public suspend inline fun CodeCatalystClient.updateSpace(crossinline block: UpdateSpaceRequest.Builder.() -> Unit): UpdateSpaceResponse = updateSpace(UpdateSpaceRequest.Builder().apply(block).build())

/**
 * Verifies whether the calling user has a valid Amazon CodeCatalyst login and session. If successful, this returns the ID of the user in Amazon CodeCatalyst.
 */
public suspend inline fun CodeCatalystClient.verifySession(crossinline block: VerifySessionRequest.Builder.() -> Unit): VerifySessionResponse = verifySession(VerifySessionRequest.Builder().apply(block).build())
