// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.serde

import aws.sdk.kotlin.services.codecatalyst.model.CodeCatalystException
import aws.sdk.kotlin.services.codecatalyst.model.StopDevEnvironmentSessionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StopDevEnvironmentSessionOperationDeserializer: HttpDeserializer.NonStreaming<StopDevEnvironmentSessionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): StopDevEnvironmentSessionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStopDevEnvironmentSessionError(context, call, payload)
        }
        val builder = StopDevEnvironmentSessionResponse.Builder()

        if (payload != null) {
            deserializeStopDevEnvironmentSessionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwStopDevEnvironmentSessionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCatalystException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeCatalystException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStopDevEnvironmentSessionOperationBody(builder: StopDevEnvironmentSessionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val PROJECTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectName"))
    val SESSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sessionId"))
    val SPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("spaceName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ID_DESCRIPTOR)
        field(PROJECTNAME_DESCRIPTOR)
        field(SESSIONID_DESCRIPTOR)
        field(SPACENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                PROJECTNAME_DESCRIPTOR.index -> builder.projectName = deserializeString()
                SESSIONID_DESCRIPTOR.index -> builder.sessionId = deserializeString()
                SPACENAME_DESCRIPTOR.index -> builder.spaceName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
