// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.serde

import aws.sdk.kotlin.services.codecatalyst.model.CodeCatalystException
import aws.sdk.kotlin.services.codecatalyst.model.GetWorkflowResponse
import aws.sdk.kotlin.services.codecatalyst.model.WorkflowDefinition
import aws.sdk.kotlin.services.codecatalyst.model.WorkflowRunMode
import aws.sdk.kotlin.services.codecatalyst.model.WorkflowStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetWorkflowOperationDeserializer: HttpDeserializer.NonStreaming<GetWorkflowResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetWorkflowResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetWorkflowError(context, call, payload)
        }
        val builder = GetWorkflowResponse.Builder()

        if (payload != null) {
            deserializeGetWorkflowOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetWorkflowError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCatalystException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeCatalystException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetWorkflowOperationBody(builder: GetWorkflowResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdTime"))
    val DEFINITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("definition"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val LASTUPDATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PROJECTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("projectName"))
    val RUNMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("runMode"))
    val SOURCEBRANCHNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceBranchName"))
    val SOURCEREPOSITORYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceRepositoryName"))
    val SPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("spaceName"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDTIME_DESCRIPTOR)
        field(DEFINITION_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(LASTUPDATEDTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PROJECTNAME_DESCRIPTOR)
        field(RUNMODE_DESCRIPTOR)
        field(SOURCEBRANCHNAME_DESCRIPTOR)
        field(SOURCEREPOSITORYNAME_DESCRIPTOR)
        field(SPACENAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDTIME_DESCRIPTOR.index -> builder.createdTime = deserializeInstant(TimestampFormat.ISO_8601)
                DEFINITION_DESCRIPTOR.index -> builder.definition = deserializeWorkflowDefinitionDocument(deserializer)
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                LASTUPDATEDTIME_DESCRIPTOR.index -> builder.lastUpdatedTime = deserializeInstant(TimestampFormat.ISO_8601)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PROJECTNAME_DESCRIPTOR.index -> builder.projectName = deserializeString()
                RUNMODE_DESCRIPTOR.index -> builder.runMode = deserializeString().let { WorkflowRunMode.fromValue(it) }
                SOURCEBRANCHNAME_DESCRIPTOR.index -> builder.sourceBranchName = deserializeString()
                SOURCEREPOSITORYNAME_DESCRIPTOR.index -> builder.sourceRepositoryName = deserializeString()
                SPACENAME_DESCRIPTOR.index -> builder.spaceName = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { WorkflowStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
