// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecatalyst.serde

import aws.sdk.kotlin.services.codecatalyst.model.CreateDevEnvironmentRequest
import aws.sdk.kotlin.services.codecatalyst.model.IdeConfiguration
import aws.sdk.kotlin.services.codecatalyst.model.InstanceType
import aws.sdk.kotlin.services.codecatalyst.model.PersistentStorageConfiguration
import aws.sdk.kotlin.services.codecatalyst.model.RepositoryInput
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateDevEnvironmentOperationSerializer: HttpSerializer.NonStreaming<CreateDevEnvironmentRequest> {
    override fun serialize(context: ExecutionContext, input: CreateDevEnvironmentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.spaceName) { "spaceName is bound to the URI and must not be null" }
            requireNotNull(input.projectName) { "projectName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("spaces"))
                add(PercentEncoding.SmithyLabel.encode(input.spaceName))
                add(PercentEncoding.Path.encode("projects"))
                add(PercentEncoding.SmithyLabel.encode(input.projectName))
                add(PercentEncoding.Path.encode("devEnvironments"))
            }
        }

        val payload = serializeCreateDevEnvironmentOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateDevEnvironmentOperationBody(context: ExecutionContext, input: CreateDevEnvironmentRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("alias"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val IDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ides"))
    val INACTIVITYTIMEOUTMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("inactivityTimeoutMinutes"))
    val INSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("instanceType"))
    val PERSISTENTSTORAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("persistentStorage"))
    val REPOSITORIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("repositories"))
    val VPCCONNECTIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vpcConnectionName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALIAS_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(IDES_DESCRIPTOR)
        field(INACTIVITYTIMEOUTMINUTES_DESCRIPTOR)
        field(INSTANCETYPE_DESCRIPTOR)
        field(PERSISTENTSTORAGE_DESCRIPTOR)
        field(REPOSITORIES_DESCRIPTOR)
        field(VPCCONNECTIONNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.alias?.let { field(ALIAS_DESCRIPTOR, it) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) }
        if (input.ides != null) {
            listField(IDES_DESCRIPTOR) {
                for (el0 in input.ides) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeIdeConfigurationDocument))
                }
            }
        }
        input.inactivityTimeoutMinutes?.let { field(INACTIVITYTIMEOUTMINUTES_DESCRIPTOR, it) }
        input.instanceType?.let { field(INSTANCETYPE_DESCRIPTOR, it.value) }
        input.persistentStorage?.let { field(PERSISTENTSTORAGE_DESCRIPTOR, it, ::serializePersistentStorageConfigurationDocument) }
        if (input.repositories != null) {
            listField(REPOSITORIES_DESCRIPTOR) {
                for (el0 in input.repositories) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeRepositoryInputDocument))
                }
            }
        }
        input.vpcConnectionName?.let { field(VPCCONNECTIONNAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
